package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取用户ID请求对象
 */
@ApiModel(description = "获取用户ID请求对象")

@JsonInclude(NON_NULL)
public class MsSsoGetUserIdRequest {
  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("userPhone")
  private String userPhone = null;

  @JsonProperty("userEmail")
  private String userEmail = null;

  @JsonProperty("userAccount")
  private String userAccount = null;

  @JsonIgnore
  public MsSsoGetUserIdRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsSsoGetUserIdRequest userPhone(String userPhone) {
    this.userPhone = userPhone;
    return this;
  }

   /**
   * 用户手机号
   * @return userPhone
  **/
  @ApiModelProperty(value = "用户手机号")
  public String getUserPhone() {
    return userPhone;
  }

  public void setUserPhone(String userPhone) {
    this.userPhone = userPhone;
  }

  @JsonIgnore
  public MsSsoGetUserIdRequest userEmail(String userEmail) {
    this.userEmail = userEmail;
    return this;
  }

   /**
   * 用户邮箱
   * @return userEmail
  **/
  @ApiModelProperty(value = "用户邮箱")
  public String getUserEmail() {
    return userEmail;
  }

  public void setUserEmail(String userEmail) {
    this.userEmail = userEmail;
  }

  @JsonIgnore
  public MsSsoGetUserIdRequest userAccount(String userAccount) {
    this.userAccount = userAccount;
    return this;
  }

   /**
   * 用户账户
   * @return userAccount
  **/
  @ApiModelProperty(value = "用户账户")
  public String getUserAccount() {
    return userAccount;
  }

  public void setUserAccount(String userAccount) {
    this.userAccount = userAccount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSsoGetUserIdRequest ssoGetUserIdRequest = (MsSsoGetUserIdRequest) o;
    return Objects.equals(this.tenantId, ssoGetUserIdRequest.tenantId) &&
        Objects.equals(this.userPhone, ssoGetUserIdRequest.userPhone) &&
        Objects.equals(this.userEmail, ssoGetUserIdRequest.userEmail) &&
        Objects.equals(this.userAccount, ssoGetUserIdRequest.userAccount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, userPhone, userEmail, userAccount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSsoGetUserIdRequest {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    userPhone: ").append(toIndentedString(userPhone)).append("\n");
    sb.append("    userEmail: ").append(toIndentedString(userEmail)).append("\n");
    sb.append("    userAccount: ").append(toIndentedString(userAccount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
