package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取用户ID回复对象
 */
@ApiModel(description = "获取用户ID回复对象")

@JsonInclude(NON_NULL)
public class MsSsoGetUserIdResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonIgnore
  public MsSsoGetUserIdResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code 0:失败 1:成功
   * @return code
  **/
  @ApiModelProperty(value = "return code 0:失败 1:成功")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsSsoGetUserIdResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsSsoGetUserIdResponse userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户ID
   * @return userId
  **/
  @ApiModelProperty(value = "用户ID")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSsoGetUserIdResponse ssoGetUserIdResponse = (MsSsoGetUserIdResponse) o;
    return Objects.equals(this.code, ssoGetUserIdResponse.code) &&
        Objects.equals(this.message, ssoGetUserIdResponse.message) &&
        Objects.equals(this.userId, ssoGetUserIdResponse.userId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, userId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSsoGetUserIdResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
