package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * general Response object
 */
@ApiModel(description = "general Response object")

@JsonInclude(NON_NULL)
public class MsSsoResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("coopBaseUrl")
  private String coopBaseUrl = null;

  @JsonProperty("accessToken")
  private String accessToken = null;

  @JsonIgnore
  public MsSsoResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code 0:失败 1:成功 2:处理中
   * @return code
  **/
  @ApiModelProperty(value = "return code 0:失败 1:成功 2:处理中")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsSsoResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsSsoResponse coopBaseUrl(String coopBaseUrl) {
    this.coopBaseUrl = coopBaseUrl;
    return this;
  }

   /**
   * 协同基础地址
   * @return coopBaseUrl
  **/
  @ApiModelProperty(value = "协同基础地址")
  public String getCoopBaseUrl() {
    return coopBaseUrl;
  }

  public void setCoopBaseUrl(String coopBaseUrl) {
    this.coopBaseUrl = coopBaseUrl;
  }

  @JsonIgnore
  public MsSsoResponse accessToken(String accessToken) {
    this.accessToken = accessToken;
    return this;
  }

   /**
   * 访问TOKEN
   * @return accessToken
  **/
  @ApiModelProperty(value = "访问TOKEN")
  public String getAccessToken() {
    return accessToken;
  }

  public void setAccessToken(String accessToken) {
    this.accessToken = accessToken;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSsoResponse ssoResponse = (MsSsoResponse) o;
    return Objects.equals(this.code, ssoResponse.code) &&
        Objects.equals(this.message, ssoResponse.message) &&
        Objects.equals(this.coopBaseUrl, ssoResponse.coopBaseUrl) &&
        Objects.equals(this.accessToken, ssoResponse.accessToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, coopBaseUrl, accessToken);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSsoResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    coopBaseUrl: ").append(toIndentedString(coopBaseUrl)).append("\n");
    sb.append("    accessToken: ").append(toIndentedString(accessToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
