package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 手机验证码登录发送请求
 */
@ApiModel(description = "手机验证码登录发送请求")

@JsonInclude(NON_NULL)
public class MsSsoSendSmsLoginCodeRequest {
  @JsonProperty("userPhone")
  private String userPhone = null;

  @JsonProperty("registerFlag")
  private String registerFlag = null;

  @JsonIgnore
  public MsSsoSendSmsLoginCodeRequest userPhone(String userPhone) {
    this.userPhone = userPhone;
    return this;
  }

   /**
   * 用户手机号
   * @return userPhone
  **/
  @ApiModelProperty(value = "用户手机号")
  public String getUserPhone() {
    return userPhone;
  }

  public void setUserPhone(String userPhone) {
    this.userPhone = userPhone;
  }

  @JsonIgnore
  public MsSsoSendSmsLoginCodeRequest registerFlag(String registerFlag) {
    this.registerFlag = registerFlag;
    return this;
  }

   /**
   * 注册标记  Y-表示注册 N-表示登录（不传默认为N）
   * @return registerFlag
  **/
  @ApiModelProperty(value = "注册标记  Y-表示注册 N-表示登录（不传默认为N）")
  public String getRegisterFlag() {
    return registerFlag;
  }

  public void setRegisterFlag(String registerFlag) {
    this.registerFlag = registerFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSsoSendSmsLoginCodeRequest ssoSendSmsLoginCodeRequest = (MsSsoSendSmsLoginCodeRequest) o;
    return Objects.equals(this.userPhone, ssoSendSmsLoginCodeRequest.userPhone) &&
        Objects.equals(this.registerFlag, ssoSendSmsLoginCodeRequest.registerFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userPhone, registerFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSsoSendSmsLoginCodeRequest {\n");
    
    sb.append("    userPhone: ").append(toIndentedString(userPhone)).append("\n");
    sb.append("    registerFlag: ").append(toIndentedString(registerFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
