package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsTCServicePackageBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 服务包订购请求
 */
@ApiModel(description = "服务包订购请求")

@JsonInclude(NON_NULL)
public class MsTCOrderServiceRequest {
  @JsonProperty("tenantCode")
  private String tenantCode = null;

  @JsonProperty("taxNum")
  private String taxNum = null;

  @JsonProperty("servicePackageList")
  private List<MsTCServicePackageBean> servicePackageList = new ArrayList<MsTCServicePackageBean>();

  @JsonIgnore
  public MsTCOrderServiceRequest tenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
    return this;
  }

   /**
   * 租户代码
   * @return tenantCode
  **/
  @ApiModelProperty(value = "租户代码")
  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  @JsonIgnore
  public MsTCOrderServiceRequest taxNum(String taxNum) {
    this.taxNum = taxNum;
    return this;
  }

   /**
   * 企业税号
   * @return taxNum
  **/
  @ApiModelProperty(value = "企业税号")
  public String getTaxNum() {
    return taxNum;
  }

  public void setTaxNum(String taxNum) {
    this.taxNum = taxNum;
  }

  @JsonIgnore
  public MsTCOrderServiceRequest servicePackageList(List<MsTCServicePackageBean> servicePackageList) {
    this.servicePackageList = servicePackageList;
    return this;
  }

  public MsTCOrderServiceRequest addServicePackageListItem(MsTCServicePackageBean servicePackageListItem) {
    this.servicePackageList.add(servicePackageListItem);
    return this;
  }

   /**
   * 订购服务包列表
   * @return servicePackageList
  **/
  @ApiModelProperty(value = "订购服务包列表")
  public List<MsTCServicePackageBean> getServicePackageList() {
    return servicePackageList;
  }

  public void setServicePackageList(List<MsTCServicePackageBean> servicePackageList) {
    this.servicePackageList = servicePackageList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCOrderServiceRequest tcOrderServiceRequest = (MsTCOrderServiceRequest) o;
    return Objects.equals(this.tenantCode, tcOrderServiceRequest.tenantCode) &&
        Objects.equals(this.taxNum, tcOrderServiceRequest.taxNum) &&
        Objects.equals(this.servicePackageList, tcOrderServiceRequest.servicePackageList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantCode, taxNum, servicePackageList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCOrderServiceRequest {\n");
    
    sb.append("    tenantCode: ").append(toIndentedString(tenantCode)).append("\n");
    sb.append("    taxNum: ").append(toIndentedString(taxNum)).append("\n");
    sb.append("    servicePackageList: ").append(toIndentedString(servicePackageList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
