package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 简化版公司信息
 */
@ApiModel(description = "简化版公司信息")

@JsonInclude(NON_NULL)
public class MsTCShortCompanyBean {
  @JsonProperty("taxNum")
  private String taxNum = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("taxpayerQualificationType")
  private Integer taxpayerQualificationType = null;

  @JsonIgnore
  public MsTCShortCompanyBean taxNum(String taxNum) {
    this.taxNum = taxNum;
    return this;
  }

   /**
   * 企业税号
   * @return taxNum
  **/
  @ApiModelProperty(value = "企业税号")
  public String getTaxNum() {
    return taxNum;
  }

  public void setTaxNum(String taxNum) {
    this.taxNum = taxNum;
  }

  @JsonIgnore
  public MsTCShortCompanyBean companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 企业名称
   * @return companyName
  **/
  @ApiModelProperty(value = "企业名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsTCShortCompanyBean taxpayerQualificationType(Integer taxpayerQualificationType) {
    this.taxpayerQualificationType = taxpayerQualificationType;
    return this;
  }

   /**
   * 纳税人资质类型 1:一般增值税纳税人 2:小规模纳税人
   * @return taxpayerQualificationType
  **/
  @ApiModelProperty(value = "纳税人资质类型 1:一般增值税纳税人 2:小规模纳税人")
  public Integer getTaxpayerQualificationType() {
    return taxpayerQualificationType;
  }

  public void setTaxpayerQualificationType(Integer taxpayerQualificationType) {
    this.taxpayerQualificationType = taxpayerQualificationType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCShortCompanyBean tcShortCompanyBean = (MsTCShortCompanyBean) o;
    return Objects.equals(this.taxNum, tcShortCompanyBean.taxNum) &&
        Objects.equals(this.companyName, tcShortCompanyBean.companyName) &&
        Objects.equals(this.taxpayerQualificationType, tcShortCompanyBean.taxpayerQualificationType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxNum, companyName, taxpayerQualificationType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCShortCompanyBean {\n");
    
    sb.append("    taxNum: ").append(toIndentedString(taxNum)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    taxpayerQualificationType: ").append(toIndentedString(taxpayerQualificationType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
