package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsPolicyGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * general nationalEntity object
 */
@ApiModel(description = "general nationalEntity object")

@JsonInclude(NON_NULL)
public class MsTaxNationalCode {
  @JsonProperty("taxCode")
  private String taxCode = null;

  @JsonProperty("taxName")
  private String taxName = null;

  @JsonProperty("taxShortName")
  private String taxShortName = null;

  @JsonProperty("taxPolicy")
  private String taxPolicy = null;

  @JsonProperty("taxCodeVersion")
  private String taxCodeVersion = null;

  @JsonProperty("isNode")
  private String isNode = null;

  @JsonProperty("itemTypeCode")
  private String itemTypeCode = null;

  @JsonProperty("effectiveDate")
  private String effectiveDate = null;

  @JsonProperty("expirationDate")
  private String expirationDate = null;

  @JsonProperty("taxRateList")
  private List<String> taxRateList = new ArrayList<String>();

  @JsonProperty("policyGroups")
  private List<MsPolicyGroup> policyGroups = new ArrayList<MsPolicyGroup>();

  @JsonIgnore
  public MsTaxNationalCode taxCode(String taxCode) {
    this.taxCode = taxCode;
    return this;
  }

   /**
   * 税收分类编码
   * @return taxCode
  **/
  @ApiModelProperty(value = "税收分类编码")
  public String getTaxCode() {
    return taxCode;
  }

  public void setTaxCode(String taxCode) {
    this.taxCode = taxCode;
  }

  @JsonIgnore
  public MsTaxNationalCode taxName(String taxName) {
    this.taxName = taxName;
    return this;
  }

   /**
   * 税编名称
   * @return taxName
  **/
  @ApiModelProperty(value = "税编名称")
  public String getTaxName() {
    return taxName;
  }

  public void setTaxName(String taxName) {
    this.taxName = taxName;
  }

  @JsonIgnore
  public MsTaxNationalCode taxShortName(String taxShortName) {
    this.taxShortName = taxShortName;
    return this;
  }

   /**
   * 税编简称
   * @return taxShortName
  **/
  @ApiModelProperty(value = "税编简称")
  public String getTaxShortName() {
    return taxShortName;
  }

  public void setTaxShortName(String taxShortName) {
    this.taxShortName = taxShortName;
  }

  @JsonIgnore
  public MsTaxNationalCode taxPolicy(String taxPolicy) {
    this.taxPolicy = taxPolicy;
    return this;
  }

   /**
   * 可用的优惠政策内容
   * @return taxPolicy
  **/
  @ApiModelProperty(value = "可用的优惠政策内容")
  public String getTaxPolicy() {
    return taxPolicy;
  }

  public void setTaxPolicy(String taxPolicy) {
    this.taxPolicy = taxPolicy;
  }

  @JsonIgnore
  public MsTaxNationalCode taxCodeVersion(String taxCodeVersion) {
    this.taxCodeVersion = taxCodeVersion;
    return this;
  }

   /**
   * 版本
   * @return taxCodeVersion
  **/
  @ApiModelProperty(value = "版本")
  public String getTaxCodeVersion() {
    return taxCodeVersion;
  }

  public void setTaxCodeVersion(String taxCodeVersion) {
    this.taxCodeVersion = taxCodeVersion;
  }

  @JsonIgnore
  public MsTaxNationalCode isNode(String isNode) {
    this.isNode = isNode;
    return this;
  }

   /**
   * 是否可以混开
   * @return isNode
  **/
  @ApiModelProperty(value = "是否可以混开")
  public String getIsNode() {
    return isNode;
  }

  public void setIsNode(String isNode) {
    this.isNode = isNode;
  }

  @JsonIgnore
  public MsTaxNationalCode itemTypeCode(String itemTypeCode) {
    this.itemTypeCode = itemTypeCode;
    return this;
  }

   /**
   * 分类码
   * @return itemTypeCode
  **/
  @ApiModelProperty(value = "分类码")
  public String getItemTypeCode() {
    return itemTypeCode;
  }

  public void setItemTypeCode(String itemTypeCode) {
    this.itemTypeCode = itemTypeCode;
  }

  @JsonIgnore
  public MsTaxNationalCode effectiveDate(String effectiveDate) {
    this.effectiveDate = effectiveDate;
    return this;
  }

   /**
   * 生效日期（yyyyMMdd）
   * @return effectiveDate
  **/
  @ApiModelProperty(value = "生效日期（yyyyMMdd）")
  public String getEffectiveDate() {
    return effectiveDate;
  }

  public void setEffectiveDate(String effectiveDate) {
    this.effectiveDate = effectiveDate;
  }

  @JsonIgnore
  public MsTaxNationalCode expirationDate(String expirationDate) {
    this.expirationDate = expirationDate;
    return this;
  }

   /**
   * 过渡期截止日期（yyyyMMdd）
   * @return expirationDate
  **/
  @ApiModelProperty(value = "过渡期截止日期（yyyyMMdd）")
  public String getExpirationDate() {
    return expirationDate;
  }

  public void setExpirationDate(String expirationDate) {
    this.expirationDate = expirationDate;
  }

  @JsonIgnore
  public MsTaxNationalCode taxRateList(List<String> taxRateList) {
    this.taxRateList = taxRateList;
    return this;
  }

  public MsTaxNationalCode addTaxRateListItem(String taxRateListItem) {
    this.taxRateList.add(taxRateListItem);
    return this;
  }

   /**
   * 税率
   * @return taxRateList
  **/
  @ApiModelProperty(value = "税率")
  public List<String> getTaxRateList() {
    return taxRateList;
  }

  public void setTaxRateList(List<String> taxRateList) {
    this.taxRateList = taxRateList;
  }

  @JsonIgnore
  public MsTaxNationalCode policyGroups(List<MsPolicyGroup> policyGroups) {
    this.policyGroups = policyGroups;
    return this;
  }

  public MsTaxNationalCode addPolicyGroupsItem(MsPolicyGroup policyGroupsItem) {
    this.policyGroups.add(policyGroupsItem);
    return this;
  }

   /**
   * 优惠政策分组列表
   * @return policyGroups
  **/
  @ApiModelProperty(value = "优惠政策分组列表")
  public List<MsPolicyGroup> getPolicyGroups() {
    return policyGroups;
  }

  public void setPolicyGroups(List<MsPolicyGroup> policyGroups) {
    this.policyGroups = policyGroups;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxNationalCode taxNationalCode = (MsTaxNationalCode) o;
    return Objects.equals(this.taxCode, taxNationalCode.taxCode) &&
        Objects.equals(this.taxName, taxNationalCode.taxName) &&
        Objects.equals(this.taxShortName, taxNationalCode.taxShortName) &&
        Objects.equals(this.taxPolicy, taxNationalCode.taxPolicy) &&
        Objects.equals(this.taxCodeVersion, taxNationalCode.taxCodeVersion) &&
        Objects.equals(this.isNode, taxNationalCode.isNode) &&
        Objects.equals(this.itemTypeCode, taxNationalCode.itemTypeCode) &&
        Objects.equals(this.effectiveDate, taxNationalCode.effectiveDate) &&
        Objects.equals(this.expirationDate, taxNationalCode.expirationDate) &&
        Objects.equals(this.taxRateList, taxNationalCode.taxRateList) &&
        Objects.equals(this.policyGroups, taxNationalCode.policyGroups);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxCode, taxName, taxShortName, taxPolicy, taxCodeVersion, isNode, itemTypeCode, effectiveDate, expirationDate, taxRateList, policyGroups);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxNationalCode {\n");
    
    sb.append("    taxCode: ").append(toIndentedString(taxCode)).append("\n");
    sb.append("    taxName: ").append(toIndentedString(taxName)).append("\n");
    sb.append("    taxShortName: ").append(toIndentedString(taxShortName)).append("\n");
    sb.append("    taxPolicy: ").append(toIndentedString(taxPolicy)).append("\n");
    sb.append("    taxCodeVersion: ").append(toIndentedString(taxCodeVersion)).append("\n");
    sb.append("    isNode: ").append(toIndentedString(isNode)).append("\n");
    sb.append("    itemTypeCode: ").append(toIndentedString(itemTypeCode)).append("\n");
    sb.append("    effectiveDate: ").append(toIndentedString(effectiveDate)).append("\n");
    sb.append("    expirationDate: ").append(toIndentedString(expirationDate)).append("\n");
    sb.append("    taxRateList: ").append(toIndentedString(taxRateList)).append("\n");
    sb.append("    policyGroups: ").append(toIndentedString(policyGroups)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
