package com.xforceplus.ant.system.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;

import java.io.Serializable;
import java.util.List;

/**
 * Created by hujt49 on 2019/03/13.
 */
public class Page<T> implements Serializable {

    private static final long serialVersionUID = 831365829143209871L;
    private long total;
    private int pageSize;
    private int pageIndex;
    @JsonIgnore
    private int limit;
    @JsonIgnore
    private int offset;
    private List<T> result;

    public Page(Integer pageSize, Integer pageIndex) {
        if (pageSize == null || pageSize < 1) {
            pageSize = 10000;
        }
        if (pageIndex == null || pageIndex < 1) {
            pageIndex = 1;
        }
        this.pageSize = pageSize;
        this.pageIndex = pageIndex;
        this.limit = pageSize;
        this.offset = (pageIndex - 1) * pageSize;
    }

    public int getPageSize() {
        return pageSize;
    }

    public int getPageIndex() {
        return pageIndex;
    }

    public int getLimit() {
        return limit;
    }

    public int getOffset() {
        return offset;
    }

    public List<T> getResult() {
        return result;
    }

    public void setResult(List<T> result) {
        this.result = result;
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }
}
