package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * QueryGoodsRequest
 */

@JsonInclude(NON_NULL)
public class QueryGoodsRequest {
  @JsonProperty("goodsName")
  private String goodsName = null;

  @JsonProperty("goodsNo")
  private String goodsNo = null;

  @JsonProperty("cooperatorTenantId")
  private String cooperatorTenantId = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

    @JsonProperty("returnType")
    private Integer returnType = null;

    @JsonProperty("type")
    private Integer type = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonIgnore
  public QueryGoodsRequest goodsName(String goodsName) {
    this.goodsName = goodsName;
    return this;
  }

   /**
   * 商品名称
   * @return goodsName
  **/
  @ApiModelProperty(value = "商品名称")
  public String getGoodsName() {
    return goodsName;
  }

  public void setGoodsName(String goodsName) {
    this.goodsName = goodsName;
  }

   /**
   * 协同方租户id
   * @return cooperatorTenantId
  **/
  @ApiModelProperty(value = "协同方租户id")
  public String getCooperatorTenantId() {
    return cooperatorTenantId;
  }

  public void setCooperatorTenantId(String cooperatorTenantId) {
    this.cooperatorTenantId = cooperatorTenantId;
  }

  @JsonIgnore
  public QueryGoodsRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页码数
   * @return pageNo
  **/
  @ApiModelProperty(value = "页码数")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public QueryGoodsRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 页码大小
   * @return pageSize
  **/
  @ApiModelProperty(value = "页码大小")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public QueryGoodsRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

    public String getGoodsNo() {
        return goodsNo;
    }

    public void setGoodsNo(String goodsNo) {
        this.goodsNo = goodsNo;
    }

    public Integer getReturnType() {
        return returnType;
    }

    public void setReturnType(Integer returnType) {
        this.returnType = returnType;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        QueryGoodsRequest that = (QueryGoodsRequest) o;
        return Objects.equals(goodsName, that.goodsName) &&
                Objects.equals(goodsNo, that.goodsNo) &&
                Objects.equals(cooperatorTenantId, that.cooperatorTenantId) &&
                Objects.equals(pageNo, that.pageNo) &&
                Objects.equals(pageSize, that.pageSize) &&
                Objects.equals(returnType, that.returnType) &&
                Objects.equals(type, that.type) &&
                Objects.equals(tenantId, that.tenantId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(goodsName, goodsNo, cooperatorTenantId, pageNo, pageSize, returnType, type, tenantId);
    }
}
