package com.xforceplus.ant.system.client.model;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class SyncRedNotificationRequest {
    @ApiModelProperty(value = "流水号（20个字符）")
    private String serialNo;

    @ApiModelProperty(value = "终端唯一码（与设备唯一码不能同时为空）")
    private String terminalUn;

    @ApiModelProperty(value = "设备唯一码 （单盘下载时必传，与终端唯一码不能同时为空）")
    private String deviceUn;

    @ApiModelProperty(value = "红字信息表编号（填开日期都为空时，必填）")
    private String redNotificationNo;

    @ApiModelProperty(value = "填开起始日期（红字信息表编号为空时，必填；格式：yyyyMMdd）")
    private String startDate;

    @ApiModelProperty(value = "填开截止日期（红字信息表编号为空时，必填；格式：yyyyMMdd）")
    private String endDate;

    @ApiModelProperty(value = "对应蓝票发票类型（s:纸专,se:电专;默认:s）")
    private String originalInvoiceType;
}
