package com.xforceplus.ant.system.client.api;

import java.util.List;
import com.xforceplus.ant.system.client.model.MsMenuModel;
import com.xforceplus.ant.system.client.model.MsMenuQueryModel;
import com.xforceplus.ant.system.client.model.MsResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "menu", description = "the menu API")
public interface MenuApi {

    @ApiOperation(value = "添加菜单", notes = "", response = MsResponse.class, tags={ "Menu", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果", response = MsResponse.class) })
    @RequestMapping(value = "/menu/add",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse addMenu(@ApiParam(value = "请求参数--添加菜单" ,required=true ) @RequestBody MsMenuModel menuModel);


    @ApiOperation(value = "删除菜单", notes = "", response = MsResponse.class, tags={ "Menu", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果", response = MsResponse.class) })
    @RequestMapping(value = "/menu/delete",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
     MsResponse delete( @NotNull @ApiParam(value = "请求参数--删除菜单", required = true) @RequestParam(value = "menuId", required = true) Long menuId, @NotNull @ApiParam(value = "操作类型 0-默认 1-清除消息 2-转移消息", required = true, defaultValue = "0") @RequestParam(value = "opType", required = true, defaultValue="0") Integer opType, @ApiParam(value = "转移新的菜单") @RequestParam(value = "newMenuId", required = false) Long newMenuId);


    @ApiOperation(value = "查询菜单详情", notes = "", response = MsResponse.class, tags={ "Menu", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果", response = MsResponse.class) })
    @RequestMapping(value = "/menu/info",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse info( @NotNull @ApiParam(value = "请求参数--查询菜单", required = true) @RequestParam(value = "menuId", required = true) Long menuId);


    @ApiOperation(value = "查询菜单列表", notes = "", response = MsResponse.class, tags={ "Menu", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果", response = MsResponse.class) })
    @RequestMapping(value = "/menu/list",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse list(@ApiParam(value = "请求参数--查询菜单" ,required=true ) @RequestBody MsMenuQueryModel menuQueryModel);


    @ApiOperation(value = "菜单排序", notes = "", response = MsResponse.class, tags={ "Menu", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果", response = MsResponse.class) })
    @RequestMapping(value = "/menu/order",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse order(@ApiParam(value = "请求参数--菜单ID集合" ,required=true ) @RequestBody List<Long> menuIdList);


    @ApiOperation(value = "修改菜单", notes = "", response = MsResponse.class, tags={ "Menu", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果", response = MsResponse.class) })
    @RequestMapping(value = "/menu/modify",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse update(@ApiParam(value = "请求参数--修改菜单" ,required=true ) @RequestBody MsMenuModel menuModel);

}
