package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsAddTaskRequest;
import com.xforceplus.ant.system.client.model.MsMsgSendTaskQueryRequest;
import com.xforceplus.ant.system.client.model.MsMsgSendTaskQueryResponse;
import com.xforceplus.ant.system.client.model.MsResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "msgSend", description = "the msgSend API")
public interface MsgSendApi {

    @ApiOperation(value = "添加消息任务", notes = "", response = MsResponse.class, tags={ "Common", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/msgSend/addTask",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse addTask(@ApiParam(value = "request" ,required=true ) @RequestBody MsAddTaskRequest request);


    @ApiOperation(value = "分页查询消息任务统计", notes = "", response = MsResponse.class, tags={ "Common", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/msgSend/queryTaskCount",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse queryTaskCount(@ApiParam(value = "request" ,required=true ) @RequestBody MsMsgSendTaskQueryRequest request);


    @ApiOperation(value = "分页查询消息任务", notes = "", response = MsMsgSendTaskQueryResponse.class, tags={ "Common", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsMsgSendTaskQueryResponse.class) })
    @RequestMapping(value = "/msgSend/queryTaskPage",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsMsgSendTaskQueryResponse queryTaskPage(@ApiParam(value = "request" ,required=true ) @RequestBody MsMsgSendTaskQueryRequest request);

}
