package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsInstructionModel;
import com.xforceplus.ant.system.client.model.MsInstructionQueryModel;
import com.xforceplus.ant.system.client.model.MsResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "operatingInstructions", description = "the operatingInstructions API")
public interface OperatingInstructionsApi {

    @ApiOperation(value = "新增操作指引", notes = "", response = MsResponse.class, tags={ "OperatingInstructions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/operatingInstructions/add",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse add(@ApiParam(value = "操作指引model" ,required=true ) @RequestBody MsInstructionModel instructionModel);


    @ApiOperation(value = "删除帮助消息", notes = "", response = MsResponse.class, tags={ "OperatingInstructions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/operatingInstructions/delete",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
     MsResponse delete( @NotNull @ApiParam(value = "消息ID", required = true) @RequestParam(value = "id", required = true) Long id);


    @ApiOperation(value = "启用或停用帮助消息", notes = "", response = MsResponse.class, tags={ "OperatingInstructions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/operatingInstructions/enableOrDisable",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse enableOrDisable( @NotNull @ApiParam(value = "消息ID", required = true) @RequestParam(value = "id", required = true) Long id, @NotNull @ApiParam(value = "操作类型 1-启用 0-停用", required = true) @RequestParam(value = "able", required = true) Integer able, @ApiParam(value = "操作用户id") @RequestParam(value = "opUserId", required = false) Long opUserId, @ApiParam(value = "操作用户名称") @RequestParam(value = "opUserName", required = false) String opUserName);


    @ApiOperation(value = "查询列表", notes = "", response = MsResponse.class, tags={ "OperatingInstructions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/operatingInstructions/list",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse list(@ApiParam(value = "查询model" ,required=true ) @RequestBody MsInstructionQueryModel instructionQueryModel);


    @ApiOperation(value = "更新操作指引", notes = "", response = MsResponse.class, tags={ "OperatingInstructions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/operatingInstructions/modify",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse update(@ApiParam(value = "操作指引model" ,required=true ) @RequestBody MsInstructionModel instructionModel);

}
