package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsAOrURequest;
import com.xforceplus.ant.system.client.model.MsLinkCancelRequest;
import com.xforceplus.ant.system.client.model.MsLinkCreateRequest;
import com.xforceplus.ant.system.client.model.MsResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "shortLink", description = "the shortLink API")
public interface ShortLinkApi {

    @ApiOperation(value = "修改链接", notes = "", response = MsResponse.class, tags={ "ShortLink", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/shortLink/addOrUpdate",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse addOrUpdate(@ApiParam(value = "请求参数" ,required=true ) @RequestBody MsAOrURequest request);


    @ApiOperation(value = "作废链接", notes = "", response = MsResponse.class, tags={ "ShortLink", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/shortLink/cancel",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     MsResponse cancel(@ApiParam(value = "请求参数" ,required=true ) @RequestBody MsLinkCancelRequest request);


    @ApiOperation(value = "创建短链接", notes = "", response = MsResponse.class, tags={ "ShortLink", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/shortLink/create",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse create(@ApiParam(value = "请求参数" ,required=true ) @RequestBody MsLinkCreateRequest linkRequest);


    @ApiOperation(value = "查询短链接对象", notes = "", response = MsResponse.class, tags={ "ShortLink", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/shortLink/find",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse find( @NotNull @ApiParam(value = "短链接key", required = true) @RequestParam(value = "shortKey", required = true) String shortKey);


    @ApiOperation(value = "查询员链接", notes = "", response = MsResponse.class, tags={ "ShortLink", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/shortLink/queryOriginalLink",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse queryOriginalLink( @NotNull @ApiParam(value = "短链接key", required = true) @RequestParam(value = "shortKey", required = true) String shortKey);


    @ApiOperation(value = "查询链接", notes = "", response = MsResponse.class, tags={ "ShortLink", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/shortLink/search",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse search( @NotNull @ApiParam(value = "短链接key", required = true) @RequestParam(value = "shortKey", required = true) String shortKey);

}
