package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsResponse;
import com.xforceplus.ant.system.client.model.MsSuggestAddRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "suggest", description = "the suggest API")
public interface SuggestApi {

    @ApiOperation(value = "反馈意见添加", notes = "", response = MsResponse.class, tags={ "suggest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果", response = MsResponse.class) })
    @RequestMapping(value = "/suggest/suggest",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse suggest(@ApiParam(value = "租户Id" ,required=true ) @RequestBody MsSuggestAddRequest request);

}
