package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.*;
import com.xforceplus.ant.system.client.model.redno.ApplyRedNoResult;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


@Api(value = "taxWare", description = "the taxWare API")
public interface TaxWareApi {
    @ApiOperation(value = "为公司下所有用户添加税盘设备和终端", response = MsResponse.class, tags = {"TaxWare"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = MsResponse.class)})
    @RequestMapping(value = "/taxWare/add4CompanyUser",
            produces = {"application/json"},
            method = RequestMethod.PUT)
    MsResponse add4CompanyUser(@ApiParam(value = "请求参数--公司税号", required = true) @RequestParam(value = "taxNum") String taxNum);

    @ApiOperation(value = "为为常规用户添加添加税盘设备和终端", response = MsResponse.class, tags = {"TaxWare"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = MsResponse.class)})
    @RequestMapping(value = "/taxWare/add4RegularUser",
            produces = {"application/json"},
            method = RequestMethod.PUT)
    MsResponse add4RegularUser(@ApiParam(value = "请求参数--用户ID集合", required = true) @RequestBody List<Long> userIds);

    @ApiOperation(value = "同步税盘发票信息", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/taxWare/invoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response syncTaxWareInvoices(@ApiParam(value = "parameter", required = true) @RequestBody SyncTaxWareRequest request);

    @ApiOperation(value = "同步税盘商品SPU信息", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/taxWare/syncGoods",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response syncTaxWareGoods(@ApiParam(value = "parameter", required = true) @RequestBody SyncTaxWareRequest request);

    @ApiOperation(value = "同步税盘购方抬头库信息", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/taxWare/title",
            produces = {"application/json"},
            method = RequestMethod.GET)
    Response syncTaxWareTitle(@ApiParam(value = "parameter", required = true) @RequestParam String taxNo);

    @ApiOperation(value = "查询公库和私库列表", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/taxWare/getTitles",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response getTitles(@ApiParam(value = "parameter", required = true) @RequestBody GetTitlesRequest request);

    @ApiOperation(value = "保存协同客商及抬头库信息", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/taxWare/saveCasAndTitle",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response saveCasAndTitle(@ApiParam(value = "parameter", required = true) @RequestBody SaveCasAndTitleRequest request);

    @ApiOperation(value = "保存协同客商信息(手机号/邮箱/客户编号)", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/taxWare/saveCasInfo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response saveCasInfo(@ApiParam(value = "parameter", required = true) @RequestBody SaveCasInfoRequest request);

    @ApiOperation(value = "上传文件到oss并保存url到数据库", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/oss/upload",
            produces = {"application/json"},
            method = RequestMethod.GET)
    Response uploadOss4File(@ApiParam(value = "文件路径", required = true) @RequestParam String filepath);

    @ApiOperation(value = "根据税号获取oss地址", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/oss/getUrl",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response getOssUrl(@ApiParam(value = "parameter", required = true) @RequestBody GetOssUrlRequest request);

    @ApiOperation(value = "查询红字信息表信息", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/taxWare/getRedNotification",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<RedNotificationRes> getRedNotification(@ApiParam(value = "parameter", required = true) @RequestBody GetRedNotificationRequest request);

    @ApiOperation(value = "红字信息表下载请求接口", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/taxWare/downloadRedNotification",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response downloadRedNotification(@ApiParam(value = "parameter", required = true) @RequestBody SyncRedNotificationRequest request,
                                     @ApiParam(value = "当前登录租户id", required = true) @RequestParam Long tenantId);

    @ApiOperation(value = "查询红字信息列表", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/taxWare/getRedNotificationList",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<List<RedNotificationRes>> getRedNotificationList(@ApiParam(value = "parameter", required = true) @RequestBody GetRedNotificationListRequest request);

    @ApiOperation(value = "更新红字信息表预览PDF", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/taxWare/updatePdfPreviewUrl",
            produces = {"application/json"},
            method = RequestMethod.PUT)
    Response<Integer> updatePdfPreviewUrl(@ApiParam(value = "id", required = true) @RequestParam(value = "id", required = true) Long id, @ApiParam(value = "PDF地址", required = true) @RequestParam(value = "pdfUrl", required = true) String pdfUrl);

    @ApiOperation(value = "红字信息表编号在线申请结果", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/taxWare/dealApplyRedNoResult",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response dealApplyRedNotificationResult(@ApiParam(value = "红字信息表编号在线申请结果", required = true) @RequestBody List<ApplyRedNoResult> applyRedNoResultList);

    @ApiOperation(value = "红字信息表编号在线撤销请结果", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/taxWare/dealCancelRedNoResult",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response dealCancelRedNotificationResult(@ApiParam(value = "红字信息表编号在线撤销结果", required = true) @RequestBody List<ApplyRedNoResult> applyRedNoResultList);

    @ApiOperation(value = "查询客商信息列表(手机号/邮箱/客户编号)", response = Response.class, tags = {"TaxWare",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Response.class)})
    @RequestMapping(value = "/taxWare/getCasInfos",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response getCasInfos(@ApiParam(value = "parameter", required = true) @RequestBody GetCasInfosReq request);
}
