package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "third", description = "the third API")
public interface ThirdApi {

    @ApiOperation(value = "查询公司信息", notes = "", response = MsResponse.class, tags={  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/third/companySearch",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse companySearch( @NotNull @ApiParam(value = "搜索关键字（公司名、注册号或社会统一信用代码）", required = true) @RequestParam(value = "keyword", required = true) String keyword);

}
