package com.xforceplus.ant.system.client.api.goods;

import com.xforceplus.ant.system.client.model.goods.*;
import com.xforceplus.ant.system.client.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

/**
 * Describe: 商品相关接口，不编写yaml 生成接口的 简单版本
 *
 * @Author xiezhongyong
 * @Date 2022/6/7
 */
@Api(value = "goods-sync", description = "商品管理 接口服务", tags = {"Goods"})
public interface GoodsSimpleApi {

    @ApiOperation("商品批量同步")
    @RequestMapping(value = "/goods/syncs", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<BatchGoodsSyncResp> batchSyncGoods(@RequestBody @Valid BatchGoodsSyncReq input);


    @ApiOperation("商品列表")
    @RequestMapping(value = "/goods/list", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<ListGoodsResp> listGoods(@RequestBody @Valid ListGoodsReq input);


    @ApiOperation("商品审核")
    @RequestMapping(value = "/goods/audit", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> createGoodsAudit(@RequestBody @Valid CreateGoodsAuditReq input);

    @ApiOperation("取消商品审核")
    @RequestMapping(value = "/goods/audit", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> cancelGoodsAudit(@RequestBody @Valid CancelGoodsAuditReq input);

    @ApiOperation("商品审核记录查询")
    @RequestMapping(value = "/goods/audit/record", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetGoodsRecordResp> getGoodsAuditRecord(@RequestBody @Valid GetGoodsRecordReq input);

}
