package com.xforceplus.ant.system.client.api.ucenter;

import com.xforceplus.ant.system.client.model.ucenter.UpdateAccountRequest;
import com.xforceplus.ant.system.client.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

/**
 * Describe: 用户中心账号 接口列表
 *
 * @Author xiezhongyong
 * @Date 2022-11-14
 */
@Api(value = "ucenter-account", description = "用户中心账号 接口服务", tags = {"ucetner"})
public interface UcenterAccountApi {

    @ApiOperation("修改账号")
    @RequestMapping(value = "/orgs/{accountId}", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult updateAccount(@PathVariable("accountId") Long accountId, @RequestBody @Valid UpdateAccountRequest request);

}
