package com.xforceplus.ant.system.client.api.ucenter;

import com.xforceplus.ant.system.client.model.ucenter.UcenterOrgsResponse;
import com.xforceplus.ant.system.client.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;


/**
 * Describe: 用户中心org 接口列表
 *
 * @Author xiezhongyong
 * @Date 2022-12-05
 */
@Api(value = "ucenter-orgs", description = "用户中心账号 接口服务", tags = {"ucetner"})
public interface UcenterOrgApi {

    @ApiOperation("获取租户下用户公司组织列表")
    @RequestMapping(value = "/{tenantId}/orgs/users/{userId}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<UcenterOrgsResponse>> getCompanyOrgs(@PathVariable("tenantId") Long tenantId, @PathVariable("userId") Long userId);

}
