package com.xforceplus.ant.system.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class CombinationFieldBean {
  @JsonProperty("fieldGroupIndex")
  private Integer fieldGroupIndex = null;

  @JsonProperty("field")
  private String field = null;

  @ApiModelProperty(value = "字段分组 0 主信息字段 1 明细字段")
  public Integer getFieldGroupIndex() {
    return fieldGroupIndex;
  }

  public void setFieldGroupIndex(Integer fieldGroupIndex) {
    this.fieldGroupIndex = fieldGroupIndex;
  }

  @ApiModelProperty(value = "字段名")
  public String getField() {
    return field;
  }

  public void setField(String field) {
    this.field = field;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CombinationFieldBean configBean = (CombinationFieldBean) o;
    return Objects.equals(this.fieldGroupIndex, configBean.fieldGroupIndex) &&
        Objects.equals(this.field, configBean.field);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldGroupIndex, field);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CombinationFieldBean {\n");
    sb.append("    fieldGroupIndex: ").append(toIndentedString(fieldGroupIndex)).append("\n");
    sb.append("    field: ").append(toIndentedString(field)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
