package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsAddErrorCodeLogRequest
 */

@JsonInclude(NON_NULL)
public class MsAddErrorCodeLogRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("errorCode")
  private String errorCode = null;

  @JsonProperty("requestUrl")
  private String requestUrl = null;

  @JsonProperty("userInfo")
  private String userInfo = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("responseResult")
  private String responseResult = null;

  @JsonIgnore
  public MsAddErrorCodeLogRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsAddErrorCodeLogRequest errorCode(String errorCode) {
    this.errorCode = errorCode;
    return this;
  }

   /**
   * 错误代码
   * @return errorCode
  **/
  @ApiModelProperty(value = "错误代码")
  public String getErrorCode() {
    return errorCode;
  }

  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }

  @JsonIgnore
  public MsAddErrorCodeLogRequest requestUrl(String requestUrl) {
    this.requestUrl = requestUrl;
    return this;
  }

   /**
   * 接口请求地址
   * @return requestUrl
  **/
  @ApiModelProperty(value = "接口请求地址")
  public String getRequestUrl() {
    return requestUrl;
  }

  public void setRequestUrl(String requestUrl) {
    this.requestUrl = requestUrl;
  }

  @JsonIgnore
  public MsAddErrorCodeLogRequest userInfo(String userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public String getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(String userInfo) {
    this.userInfo = userInfo;
  }

  @JsonIgnore
  public MsAddErrorCodeLogRequest companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsAddErrorCodeLogRequest companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsAddErrorCodeLogRequest responseResult(String responseResult) {
    this.responseResult = responseResult;
    return this;
  }

   /**
   * 接口返回值
   * @return responseResult
  **/
  @ApiModelProperty(value = "接口返回值")
  public String getResponseResult() {
    return responseResult;
  }

  public void setResponseResult(String responseResult) {
    this.responseResult = responseResult;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAddErrorCodeLogRequest addErrorCodeLogRequest = (MsAddErrorCodeLogRequest) o;
    return Objects.equals(this.id, addErrorCodeLogRequest.id) &&
        Objects.equals(this.errorCode, addErrorCodeLogRequest.errorCode) &&
        Objects.equals(this.requestUrl, addErrorCodeLogRequest.requestUrl) &&
        Objects.equals(this.userInfo, addErrorCodeLogRequest.userInfo) &&
        Objects.equals(this.companyTaxNo, addErrorCodeLogRequest.companyTaxNo) &&
        Objects.equals(this.companyName, addErrorCodeLogRequest.companyName) &&
        Objects.equals(this.responseResult, addErrorCodeLogRequest.responseResult);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, errorCode, requestUrl, userInfo, companyTaxNo, companyName, responseResult);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAddErrorCodeLogRequest {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
    sb.append("    requestUrl: ").append(toIndentedString(requestUrl)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    responseResult: ").append(toIndentedString(responseResult)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
