package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsCrmContactBean
 */

@JsonInclude(NON_NULL)
public class MsCrmContactBean {
  @JsonProperty("address")
  private String address = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("contactsId")
  private Integer contactsId = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("mobile")
  private String mobile = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("post")
  private String post = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonIgnore
  public MsCrmContactBean address(String address) {
    this.address = address;
    return this;
  }

   /**
   * 地址
   * @return address
  **/
  @ApiModelProperty(value = "地址")
  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  @JsonIgnore
  public MsCrmContactBean companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsCrmContactBean contactsId(Integer contactsId) {
    this.contactsId = contactsId;
    return this;
  }

   /**
   * 联系人ID
   * @return contactsId
  **/
  @ApiModelProperty(value = "联系人ID")
  public Integer getContactsId() {
    return contactsId;
  }

  public void setContactsId(Integer contactsId) {
    this.contactsId = contactsId;
  }

  @JsonIgnore
  public MsCrmContactBean companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsCrmContactBean createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsCrmContactBean email(String email) {
    this.email = email;
    return this;
  }

   /**
   * e-mail
   * @return email
  **/
  @ApiModelProperty(value = "e-mail")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  @JsonIgnore
  public MsCrmContactBean mobile(String mobile) {
    this.mobile = mobile;
    return this;
  }

   /**
   * 电话
   * @return mobile
  **/
  @ApiModelProperty(value = "电话")
  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  @JsonIgnore
  public MsCrmContactBean name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 名称
   * @return name
  **/
  @ApiModelProperty(value = "名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @JsonIgnore
  public MsCrmContactBean post(String post) {
    this.post = post;
    return this;
  }

   /**
   * 职位
   * @return post
  **/
  @ApiModelProperty(value = "职位")
  public String getPost() {
    return post;
  }

  public void setPost(String post) {
    this.post = post;
  }

  @JsonIgnore
  public MsCrmContactBean remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCrmContactBean crmContactBean = (MsCrmContactBean) o;
    return Objects.equals(this.address, crmContactBean.address) &&
        Objects.equals(this.companyName, crmContactBean.companyName) &&
        Objects.equals(this.contactsId, crmContactBean.contactsId) &&
        Objects.equals(this.companyTaxNo, crmContactBean.companyTaxNo) &&
        Objects.equals(this.createTime, crmContactBean.createTime) &&
        Objects.equals(this.email, crmContactBean.email) &&
        Objects.equals(this.mobile, crmContactBean.mobile) &&
        Objects.equals(this.name, crmContactBean.name) &&
        Objects.equals(this.post, crmContactBean.post) &&
        Objects.equals(this.remark, crmContactBean.remark);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, companyName, contactsId, companyTaxNo, createTime, email, mobile, name, post, remark);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCrmContactBean {\n");
    
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    contactsId: ").append(toIndentedString(contactsId)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    mobile: ").append(toIndentedString(mobile)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    post: ").append(toIndentedString(post)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
