package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsCrmProductBean
 */

@JsonInclude(NON_NULL)
public class MsCrmProductBean {
  @JsonProperty("productId")
  private String productId = null;

  @JsonProperty("num")
  private String num = null;

  @JsonProperty("name")
  private String name = null;

  @JsonIgnore
  public MsCrmProductBean productId(String productId) {
    this.productId = productId;
    return this;
  }

   /**
   * 产品ID
   * @return productId
  **/
  @ApiModelProperty(value = "产品ID")
  public String getProductId() {
    return productId;
  }

  public void setProductId(String productId) {
    this.productId = productId;
  }

  @JsonIgnore
  public MsCrmProductBean num(String num) {
    this.num = num;
    return this;
  }

   /**
   * 产品编码
   * @return num
  **/
  @ApiModelProperty(value = "产品编码")
  public String getNum() {
    return num;
  }

  public void setNum(String num) {
    this.num = num;
  }

  @JsonIgnore
  public MsCrmProductBean name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 产品名称
   * @return name
  **/
  @ApiModelProperty(value = "产品名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCrmProductBean crmProductBean = (MsCrmProductBean) o;
    return Objects.equals(this.productId, crmProductBean.productId) &&
        Objects.equals(this.num, crmProductBean.num) &&
        Objects.equals(this.name, crmProductBean.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productId, num, name);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCrmProductBean {\n");
    
    sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
    sb.append("    num: ").append(toIndentedString(num)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
