package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsCoopGoodsModel;
import com.xforceplus.ant.system.client.model.MsGoodsModel;
import com.xforceplus.ant.system.client.model.MsTaxCodeModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsGoodsDetailModel
 */

@JsonInclude(NON_NULL)
public class MsGoodsDetailModel {
  @JsonProperty("goods")
  private MsGoodsModel goods = null;

  @JsonProperty("coopGoods")
  private List<MsCoopGoodsModel> coopGoods = new ArrayList<MsCoopGoodsModel>();

  @JsonProperty("taxCodeList")
  private List<MsTaxCodeModel> taxCodeList = new ArrayList<MsTaxCodeModel>();

  @JsonIgnore
  public MsGoodsDetailModel goods(MsGoodsModel goods) {
    this.goods = goods;
    return this;
  }

   /**
   * 商品信息
   * @return goods
  **/
  @ApiModelProperty(value = "商品信息")
  public MsGoodsModel getGoods() {
    return goods;
  }

  public void setGoods(MsGoodsModel goods) {
    this.goods = goods;
  }

  @JsonIgnore
  public MsGoodsDetailModel coopGoods(List<MsCoopGoodsModel> coopGoods) {
    this.coopGoods = coopGoods;
    return this;
  }

  public MsGoodsDetailModel addCoopGoodsItem(MsCoopGoodsModel coopGoodsItem) {
    this.coopGoods.add(coopGoodsItem);
    return this;
  }

   /**
   * 协同商品数组
   * @return coopGoods
  **/
  @ApiModelProperty(value = "协同商品数组")
  public List<MsCoopGoodsModel> getCoopGoods() {
    return coopGoods;
  }

  public void setCoopGoods(List<MsCoopGoodsModel> coopGoods) {
    this.coopGoods = coopGoods;
  }

  @JsonIgnore
  public MsGoodsDetailModel taxCodeList(List<MsTaxCodeModel> taxCodeList) {
    this.taxCodeList = taxCodeList;
    return this;
  }

  public MsGoodsDetailModel addTaxCodeListItem(MsTaxCodeModel taxCodeListItem) {
    this.taxCodeList.add(taxCodeListItem);
    return this;
  }

   /**
   * 税编数组
   * @return taxCodeList
  **/
  @ApiModelProperty(value = "税编数组")
  public List<MsTaxCodeModel> getTaxCodeList() {
    return taxCodeList;
  }

  public void setTaxCodeList(List<MsTaxCodeModel> taxCodeList) {
    this.taxCodeList = taxCodeList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGoodsDetailModel goodsDetailModel = (MsGoodsDetailModel) o;
    return Objects.equals(this.goods, goodsDetailModel.goods) &&
        Objects.equals(this.coopGoods, goodsDetailModel.coopGoods) &&
        Objects.equals(this.taxCodeList, goodsDetailModel.taxCodeList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goods, coopGoods, taxCodeList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGoodsDetailModel {\n");
    
    sb.append("    goods: ").append(toIndentedString(goods)).append("\n");
    sb.append("    coopGoods: ").append(toIndentedString(coopGoods)).append("\n");
    sb.append("    taxCodeList: ").append(toIndentedString(taxCodeList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
