package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询消息model
 */
@ApiModel(description = "查询消息model")

@JsonInclude(NON_NULL)
public class MsInstructionQueryModel {
  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("pageIndex")
  private Integer pageIndex = null;

  @JsonProperty("typeCode")
  private String typeCode = null;

  @JsonProperty("title")
  private String title = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("groupIds")
  private List<Long> groupIds = new ArrayList<Long>();

  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonIgnore
  public MsInstructionQueryModel pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 页面展示数据数量
   * @return pageSize
  **/
  @ApiModelProperty(value = "页面展示数据数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsInstructionQueryModel pageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
    return this;
  }

   /**
   * 页面当前页数
   * @return pageIndex
  **/
  @ApiModelProperty(value = "页面当前页数")
  public Integer getPageIndex() {
    return pageIndex;
  }

  public void setPageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
  }

  @JsonIgnore
  public MsInstructionQueryModel typeCode(String typeCode) {
    this.typeCode = typeCode;
    return this;
  }

   /**
   * Get typeCode
   * @return typeCode
  **/
  @ApiModelProperty(value = "")
  public String getTypeCode() {
    return typeCode;
  }

  public void setTypeCode(String typeCode) {
    this.typeCode = typeCode;
  }

  @JsonIgnore
  public MsInstructionQueryModel title(String title) {
    this.title = title;
    return this;
  }

   /**
   * 主题 模糊搜索
   * @return title
  **/
  @ApiModelProperty(value = "主题 模糊搜索")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  @JsonIgnore
  public MsInstructionQueryModel status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态 1-启用 0-停用
   * @return status
  **/
  @ApiModelProperty(value = "状态 1-启用 0-停用")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsInstructionQueryModel groupIds(List<Long> groupIds) {
    this.groupIds = groupIds;
    return this;
  }

  public MsInstructionQueryModel addGroupIdsItem(Long groupIdsItem) {
    this.groupIds.add(groupIdsItem);
    return this;
  }

   /**
   * 特定购方租户id集合
   * @return groupIds
  **/
  @ApiModelProperty(value = "特定购方租户id集合")
  public List<Long> getGroupIds() {
    return groupIds;
  }

  public void setGroupIds(List<Long> groupIds) {
    this.groupIds = groupIds;
  }

  @JsonIgnore
  public MsInstructionQueryModel opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作用户id
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作用户id")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsInstructionQueryModel opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作用户名称
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作用户名称")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInstructionQueryModel instructionQueryModel = (MsInstructionQueryModel) o;
    return Objects.equals(this.pageSize, instructionQueryModel.pageSize) &&
        Objects.equals(this.pageIndex, instructionQueryModel.pageIndex) &&
        Objects.equals(this.typeCode, instructionQueryModel.typeCode) &&
        Objects.equals(this.title, instructionQueryModel.title) &&
        Objects.equals(this.status, instructionQueryModel.status) &&
        Objects.equals(this.groupIds, instructionQueryModel.groupIds) &&
        Objects.equals(this.opUserId, instructionQueryModel.opUserId) &&
        Objects.equals(this.opUserName, instructionQueryModel.opUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageSize, pageIndex, typeCode, title, status, groupIds, opUserId, opUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInstructionQueryModel {\n");
    
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    pageIndex: ").append(toIndentedString(pageIndex)).append("\n");
    sb.append("    typeCode: ").append(toIndentedString(typeCode)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    groupIds: ").append(toIndentedString(groupIds)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
