package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsModifyGoodsModel
 */

@JsonInclude(NON_NULL)
public class MsModifyGoodsModel {
  @JsonProperty("goodsNo")
  private String goodsNo = null;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("purchaseTenantId")
  private Long purchaseTenantId = null;

  @JsonProperty("purchaseTaxNo")
  private String purchaseTaxNo = null;

  @JsonProperty("purchaseCompanyName")
  private String purchaseCompanyName = null;

  @JsonProperty("tid")
  private String tid = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("oldGoodsName")
  private String oldGoodsName = null;

  @JsonProperty("newGoodsName")
  private String newGoodsName = null;

  @JsonProperty("oldGoodsTaxCode")
  private String oldGoodsTaxCode = null;

  @JsonProperty("newGoodsTaxCode")
  private String newGoodsTaxCode = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("unitModel")
  private String unitModel = null;

  @JsonProperty("goodsDiscountRate")
  private String goodsDiscountRate = null;

  @ApiModelProperty("优惠政策内容-新值")
  private String newTaxPreCon;
  @ApiModelProperty("优惠政策内容-旧值")
  private String oldTaxPreCon;

  @ApiModelProperty("即征即退类型-新值")
  private String newTaxCollectionRefundDetail;
  @ApiModelProperty("即征即退类型-旧值")
  private String oldTaxCollectionRefundDetail;

  @ApiModelProperty("是否享受优惠内容-新值")
  private String newTaxPre;
  @ApiModelProperty("是否享受优惠内容-旧值")
  private String oldTaxPre;

  @ApiModelProperty("零税率-新值")
  private String newZeroTax;
  @ApiModelProperty("零税率-旧值")
  private String oldZeroTax;

  @JsonIgnore
  public MsModifyGoodsModel goodsNo(String goodsNo) {
    this.goodsNo = goodsNo;
    return this;
  }

   /**
   * 商品编码
   * @return goodsNo
  **/
  @ApiModelProperty(value = "商品编码")
  public String getGoodsNo() {
    return goodsNo;
  }

  public void setGoodsNo(String goodsNo) {
    this.goodsNo = goodsNo;
  }

  @JsonIgnore
  public MsModifyGoodsModel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 商品id
   * @return id
  **/
  @ApiModelProperty(value = "商品id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsModifyGoodsModel purchaseTenantId(Long purchaseTenantId) {
    this.purchaseTenantId = purchaseTenantId;
    return this;
  }

   /**
   * 协同方租户id
   * @return purchaseTenantId
  **/
  @ApiModelProperty(value = "协同方租户id")
  public Long getPurchaseTenantId() {
    return purchaseTenantId;
  }

  public void setPurchaseTenantId(Long purchaseTenantId) {
    this.purchaseTenantId = purchaseTenantId;
  }

  @JsonIgnore
  public MsModifyGoodsModel purchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
    return this;
  }

   /**
   * Get purchaseTaxNo
   * @return purchaseTaxNo
  **/
  @ApiModelProperty(value = "")
  public String getPurchaseTaxNo() {
    return purchaseTaxNo;
  }

  public void setPurchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
  }

  @JsonIgnore
  public MsModifyGoodsModel purchaseCompanyName(String purchaseCompanyName) {
    this.purchaseCompanyName = purchaseCompanyName;
    return this;
  }

   /**
   * Get purchaseCompanyName
   * @return purchaseCompanyName
  **/
  @ApiModelProperty(value = "")
  public String getPurchaseCompanyName() {
    return purchaseCompanyName;
  }

  public void setPurchaseCompanyName(String purchaseCompanyName) {
    this.purchaseCompanyName = purchaseCompanyName;
  }

  @JsonIgnore
  public MsModifyGoodsModel tid(String tid) {
    this.tid = tid;
    return this;
  }

   /**
   * 全局业务跟踪号，供应商每发起新的流程，重新生成此值，商品服务根据此值读取审核日志的具体信息
   * @return tid
  **/
  @ApiModelProperty(value = "全局业务跟踪号，供应商每发起新的流程，重新生成此值，商品服务根据此值读取审核日志的具体信息")
  public String getTid() {
    return tid;
  }

  public void setTid(String tid) {
    this.tid = tid;
  }

  @JsonIgnore
  public MsModifyGoodsModel status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 商品初始化状态，默认： 0 = 初始化， 1= 待审核， 2= 驳回，3=已审核
   * @return status
  **/
  @ApiModelProperty(value = "商品初始化状态，默认： 0 = 初始化， 1= 待审核， 2= 驳回，3=已审核")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public MsModifyGoodsModel oldGoodsName(String oldGoodsName) {
    this.oldGoodsName = oldGoodsName;
    return this;
  }

   /**
   * Get oldGoodsName
   * @return oldGoodsName
  **/
  @ApiModelProperty(value = "")
  public String getOldGoodsName() {
    return oldGoodsName;
  }

  public void setOldGoodsName(String oldGoodsName) {
    this.oldGoodsName = oldGoodsName;
  }

  @JsonIgnore
  public MsModifyGoodsModel newGoodsName(String newGoodsName) {
    this.newGoodsName = newGoodsName;
    return this;
  }

   /**
   * Get newGoodsName
   * @return newGoodsName
  **/
  @ApiModelProperty(value = "")
  public String getNewGoodsName() {
    return newGoodsName;
  }

  public void setNewGoodsName(String newGoodsName) {
    this.newGoodsName = newGoodsName;
  }

  @JsonIgnore
  public MsModifyGoodsModel oldGoodsTaxCode(String oldGoodsTaxCode) {
    this.oldGoodsTaxCode = oldGoodsTaxCode;
    return this;
  }

   /**
   * Get oldGoodsTaxCode
   * @return oldGoodsTaxCode
  **/
  @ApiModelProperty(value = "")
  public String getOldGoodsTaxCode() {
    return oldGoodsTaxCode;
  }

  public void setOldGoodsTaxCode(String oldGoodsTaxCode) {
    this.oldGoodsTaxCode = oldGoodsTaxCode;
  }

  @JsonIgnore
  public MsModifyGoodsModel newGoodsTaxCode(String newGoodsTaxCode) {
    this.newGoodsTaxCode = newGoodsTaxCode;
    return this;
  }

   /**
   * Get newGoodsTaxCode
   * @return newGoodsTaxCode
  **/
  @ApiModelProperty(value = "")
  public String getNewGoodsTaxCode() {
    return newGoodsTaxCode;
  }

  public void setNewGoodsTaxCode(String newGoodsTaxCode) {
    this.newGoodsTaxCode = newGoodsTaxCode;
  }

  @JsonIgnore
  public MsModifyGoodsModel quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 单位模式为件箱模式时，请提供此值
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "单位模式为件箱模式时，请提供此值")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public MsModifyGoodsModel unitModel(String unitModel) {
    this.unitModel = unitModel;
    return this;
  }

   /**
   * 商品的单位模式，默认为数量模式 0= 数量模式， 1 = 件箱模式
   * @return unitModel
  **/
  @ApiModelProperty(value = "商品的单位模式，默认为数量模式 0= 数量模式， 1 = 件箱模式")
  public String getUnitModel() {
    return unitModel;
  }

  public void setUnitModel(String unitModel) {
    this.unitModel = unitModel;
  }

  @JsonIgnore
  public MsModifyGoodsModel goodsDiscountRate(String goodsDiscountRate) {
    this.goodsDiscountRate = goodsDiscountRate;
    return this;
  }

   /**
   * 商品的最大折扣率
   * @return goodsDiscountRate
  **/
  @ApiModelProperty(value = "商品的最大折扣率")
  public String getGoodsDiscountRate() {
    return goodsDiscountRate;
  }

  public void setGoodsDiscountRate(String goodsDiscountRate) {
    this.goodsDiscountRate = goodsDiscountRate;
  }

  public String getNewTaxPreCon() {
    return newTaxPreCon;
  }

  public void setNewTaxPreCon(String newTaxPreCon) {
    this.newTaxPreCon = newTaxPreCon;
  }

  public String getOldTaxPreCon() {
    return oldTaxPreCon;
  }

  public void setOldTaxPreCon(String oldTaxPreCon) {
    this.oldTaxPreCon = oldTaxPreCon;
  }

  public String getNewTaxCollectionRefundDetail() {
    return newTaxCollectionRefundDetail;
  }

  public void setNewTaxCollectionRefundDetail(String newTaxCollectionRefundDetail) {
    this.newTaxCollectionRefundDetail = newTaxCollectionRefundDetail;
  }

  public String getOldTaxCollectionRefundDetail() {
    return oldTaxCollectionRefundDetail;
  }

  public void setOldTaxCollectionRefundDetail(String oldTaxCollectionRefundDetail) {
    this.oldTaxCollectionRefundDetail = oldTaxCollectionRefundDetail;
  }

  public String getNewTaxPre() {
    return newTaxPre;
  }

  public void setNewTaxPre(String newTaxPre) {
    this.newTaxPre = newTaxPre;
  }

  public String getOldTaxPre() {
    return oldTaxPre;
  }

  public void setOldTaxPre(String oldTaxPre) {
    this.oldTaxPre = oldTaxPre;
  }

  public String getNewZeroTax() {
    return newZeroTax;
  }

  public void setNewZeroTax(String newZeroTax) {
    this.newZeroTax = newZeroTax;
  }

  public String getOldZeroTax() {
    return oldZeroTax;
  }

  public void setOldZeroTax(String oldZeroTax) {
    this.oldZeroTax = oldZeroTax;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsModifyGoodsModel modifyGoodsModel = (MsModifyGoodsModel) o;
    return Objects.equals(this.goodsNo, modifyGoodsModel.goodsNo) &&
        Objects.equals(this.id, modifyGoodsModel.id) &&
        Objects.equals(this.purchaseTenantId, modifyGoodsModel.purchaseTenantId) &&
        Objects.equals(this.purchaseTaxNo, modifyGoodsModel.purchaseTaxNo) &&
        Objects.equals(this.purchaseCompanyName, modifyGoodsModel.purchaseCompanyName) &&
        Objects.equals(this.tid, modifyGoodsModel.tid) &&
        Objects.equals(this.status, modifyGoodsModel.status) &&
        Objects.equals(this.oldGoodsName, modifyGoodsModel.oldGoodsName) &&
        Objects.equals(this.newGoodsName, modifyGoodsModel.newGoodsName) &&
        Objects.equals(this.oldGoodsTaxCode, modifyGoodsModel.oldGoodsTaxCode) &&
        Objects.equals(this.newGoodsTaxCode, modifyGoodsModel.newGoodsTaxCode) &&
        Objects.equals(this.quantityUnit, modifyGoodsModel.quantityUnit) &&
        Objects.equals(this.unitModel, modifyGoodsModel.unitModel) &&
        Objects.equals(this.goodsDiscountRate, modifyGoodsModel.goodsDiscountRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsNo, id, purchaseTenantId, purchaseTaxNo, purchaseCompanyName, tid, status, oldGoodsName, newGoodsName, oldGoodsTaxCode, newGoodsTaxCode, quantityUnit, unitModel, goodsDiscountRate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsModifyGoodsModel {\n");
    
    sb.append("    goodsNo: ").append(toIndentedString(goodsNo)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    purchaseTenantId: ").append(toIndentedString(purchaseTenantId)).append("\n");
    sb.append("    purchaseTaxNo: ").append(toIndentedString(purchaseTaxNo)).append("\n");
    sb.append("    purchaseCompanyName: ").append(toIndentedString(purchaseCompanyName)).append("\n");
    sb.append("    tid: ").append(toIndentedString(tid)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    oldGoodsName: ").append(toIndentedString(oldGoodsName)).append("\n");
    sb.append("    newGoodsName: ").append(toIndentedString(newGoodsName)).append("\n");
    sb.append("    oldGoodsTaxCode: ").append(toIndentedString(oldGoodsTaxCode)).append("\n");
    sb.append("    newGoodsTaxCode: ").append(toIndentedString(newGoodsTaxCode)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    unitModel: ").append(toIndentedString(unitModel)).append("\n");
    sb.append("    goodsDiscountRate: ").append(toIndentedString(goodsDiscountRate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
