package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsOperateLogQueryRequest
 */

@JsonInclude(NON_NULL)
public class MsOperateLogQueryRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("currentPage")
  private Integer currentPage = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("operateName")
  private String operateName = null;

  @JsonIgnore
  public MsOperateLogQueryRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsOperateLogQueryRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 页面展示数据数量
   * @return pageSize
  **/
  @ApiModelProperty(value = "页面展示数据数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsOperateLogQueryRequest currentPage(Integer currentPage) {
    this.currentPage = currentPage;
    return this;
  }

   /**
   * 页面当前页数
   * @return currentPage
  **/
  @ApiModelProperty(value = "页面当前页数")
  public Integer getCurrentPage() {
    return currentPage;
  }

  public void setCurrentPage(Integer currentPage) {
    this.currentPage = currentPage;
  }

  @JsonIgnore
  public MsOperateLogQueryRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsOperateLogQueryRequest email(String email) {
    this.email = email;
    return this;
  }

   /**
   * 电子邮件
   * @return email
  **/
  @ApiModelProperty(value = "电子邮件")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  @JsonIgnore
  public MsOperateLogQueryRequest operateName(String operateName) {
    this.operateName = operateName;
    return this;
  }

   /**
   * 操作名称
   * @return operateName
  **/
  @ApiModelProperty(value = "操作名称")
  public String getOperateName() {
    return operateName;
  }

  public void setOperateName(String operateName) {
    this.operateName = operateName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateLogQueryRequest operateLogQueryRequest = (MsOperateLogQueryRequest) o;
    return Objects.equals(this.id, operateLogQueryRequest.id) &&
        Objects.equals(this.pageSize, operateLogQueryRequest.pageSize) &&
        Objects.equals(this.currentPage, operateLogQueryRequest.currentPage) &&
        Objects.equals(this.userId, operateLogQueryRequest.userId) &&
        Objects.equals(this.email, operateLogQueryRequest.email) &&
        Objects.equals(this.operateName, operateLogQueryRequest.operateName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, pageSize, currentPage, userId, email, operateName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateLogQueryRequest {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    currentPage: ").append(toIndentedString(currentPage)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    operateName: ").append(toIndentedString(operateName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
