package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 返回数据
 */
@ApiModel(description = "返回数据")

@JsonInclude(NON_NULL)
public class MsQueryAuthLoginResponseResult {
  @JsonProperty("status")
  private String status = null;

  @JsonProperty("userToken")
  private String userToken = null;

  @JsonIgnore
  public MsQueryAuthLoginResponseResult status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 登录状态 login-已登录 ready-准备授权 wait-等待授权 expired-已过期
   * @return status
  **/
  @ApiModelProperty(value = "登录状态 login-已登录 ready-准备授权 wait-等待授权 expired-已过期")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public MsQueryAuthLoginResponseResult userToken(String userToken) {
    this.userToken = userToken;
    return this;
  }

   /**
   * status=login时，表示用户登录token，status=wait时，表示用户openId
   * @return userToken
  **/
  @ApiModelProperty(value = "status=login时，表示用户登录token，status=wait时，表示用户openId")
  public String getUserToken() {
    return userToken;
  }

  public void setUserToken(String userToken) {
    this.userToken = userToken;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsQueryAuthLoginResponseResult queryAuthLoginResponseResult = (MsQueryAuthLoginResponseResult) o;
    return Objects.equals(this.status, queryAuthLoginResponseResult.status) &&
        Objects.equals(this.userToken, queryAuthLoginResponseResult.userToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, userToken);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsQueryAuthLoginResponseResult {\n");
    
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    userToken: ").append(toIndentedString(userToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
