package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsQueryGoodsListRequest
 */

@JsonInclude(NON_NULL)
public class MsQueryGoodsListRequest {
  @JsonProperty("goodsNos")
  private List<String> goodsNos = new ArrayList<String>();

  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("purchaseTenantId")
  private Long purchaseTenantId = null;

  @JsonProperty("purchaseTaxNo")
  private String purchaseTaxNo = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("requestId")
  private String requestId = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonIgnore
  public MsQueryGoodsListRequest goodsNos(List<String> goodsNos) {
    this.goodsNos = goodsNos;
    return this;
  }

  public MsQueryGoodsListRequest addGoodsNosItem(String goodsNosItem) {
    this.goodsNos.add(goodsNosItem);
    return this;
  }

   /**
   * 商品编码
   * @return goodsNos
  **/
  @ApiModelProperty(value = "商品编码")
  public List<String> getGoodsNos() {
    return goodsNos;
  }

  public void setGoodsNos(List<String> goodsNos) {
    this.goodsNos = goodsNos;
  }

  @JsonIgnore
  public MsQueryGoodsListRequest sellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

   /**
   * 租户id
   * @return sellerTenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public MsQueryGoodsListRequest purchaseTenantId(Long purchaseTenantId) {
    this.purchaseTenantId = purchaseTenantId;
    return this;
  }

   /**
   * 协同方租户id
   * @return purchaseTenantId
  **/
  @ApiModelProperty(value = "协同方租户id")
  public Long getPurchaseTenantId() {
    return purchaseTenantId;
  }

  public void setPurchaseTenantId(Long purchaseTenantId) {
    this.purchaseTenantId = purchaseTenantId;
  }

  @JsonIgnore
  public MsQueryGoodsListRequest purchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
    return this;
  }

   /**
   * Get purchaseTaxNo
   * @return purchaseTaxNo
  **/
  @ApiModelProperty(value = "")
  public String getPurchaseTaxNo() {
    return purchaseTaxNo;
  }

  public void setPurchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
  }

  @JsonIgnore
  public MsQueryGoodsListRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * Get sellerTaxNo
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsQueryGoodsListRequest requestId(String requestId) {
    this.requestId = requestId;
    return this;
  }

   /**
   * Get requestId
   * @return requestId
  **/
  @ApiModelProperty(value = "")
  public String getRequestId() {
    return requestId;
  }

  public void setRequestId(String requestId) {
    this.requestId = requestId;
  }

  @JsonIgnore
  public MsQueryGoodsListRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页码
   * @return pageNo
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsQueryGoodsListRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsQueryGoodsListRequest queryGoodsListRequest = (MsQueryGoodsListRequest) o;
    return Objects.equals(this.goodsNos, queryGoodsListRequest.goodsNos) &&
        Objects.equals(this.sellerTenantId, queryGoodsListRequest.sellerTenantId) &&
        Objects.equals(this.purchaseTenantId, queryGoodsListRequest.purchaseTenantId) &&
        Objects.equals(this.purchaseTaxNo, queryGoodsListRequest.purchaseTaxNo) &&
        Objects.equals(this.sellerTaxNo, queryGoodsListRequest.sellerTaxNo) &&
        Objects.equals(this.requestId, queryGoodsListRequest.requestId) &&
        Objects.equals(this.pageNo, queryGoodsListRequest.pageNo) &&
        Objects.equals(this.pageSize, queryGoodsListRequest.pageSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsNos, sellerTenantId, purchaseTenantId, purchaseTaxNo, sellerTaxNo, requestId, pageNo, pageSize);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsQueryGoodsListRequest {\n");
    
    sb.append("    goodsNos: ").append(toIndentedString(goodsNos)).append("\n");
    sb.append("    sellerTenantId: ").append(toIndentedString(sellerTenantId)).append("\n");
    sb.append("    purchaseTenantId: ").append(toIndentedString(purchaseTenantId)).append("\n");
    sb.append("    purchaseTaxNo: ").append(toIndentedString(purchaseTaxNo)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    requestId: ").append(toIndentedString(requestId)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
