package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsQueryGoodsListV2Request
 */

@JsonInclude(NON_NULL)
public class MsQueryGoodsListV2Request {
  @JsonProperty("cooperatorGoodsNo")
  private String cooperatorGoodsNo = null;

  @JsonProperty("cooperatorTenantId")
  private Long cooperatorTenantId = null;

  @JsonProperty("cooperatorTaxNo")
  private String cooperatorTaxNo = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("goodsName")
  private String goodsName = null;

  @JsonProperty("goodsNo")
  private String goodsNo = null;

  @JsonProperty("returnType")
  private Integer returnType = null;

  @JsonProperty("type")
  private Integer type = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("hasCooperator")
  private Boolean hasCooperator = null;

  @JsonIgnore
  public MsQueryGoodsListV2Request cooperatorGoodsNo(String cooperatorGoodsNo) {
    this.cooperatorGoodsNo = cooperatorGoodsNo;
    return this;
  }

   /**
   * 协同方商品编码
   * @return cooperatorGoodsNo
  **/
  @ApiModelProperty(value = "协同方商品编码")
  public String getCooperatorGoodsNo() {
    return cooperatorGoodsNo;
  }

  public void setCooperatorGoodsNo(String cooperatorGoodsNo) {
    this.cooperatorGoodsNo = cooperatorGoodsNo;
  }

  @JsonIgnore
  public MsQueryGoodsListV2Request cooperatorTenantId(Long cooperatorTenantId) {
    this.cooperatorTenantId = cooperatorTenantId;
    return this;
  }

   /**
   * 协同方租户id
   * @return cooperatorTenantId
  **/
  @ApiModelProperty(value = "协同方租户id")
  public Long getCooperatorTenantId() {
    return cooperatorTenantId;
  }

  public void setCooperatorTenantId(Long cooperatorTenantId) {
    this.cooperatorTenantId = cooperatorTenantId;
  }

  @JsonIgnore
  public MsQueryGoodsListV2Request cooperatorTaxNo(String cooperatorTaxNo) {
    this.cooperatorTaxNo = cooperatorTaxNo;
    return this;
  }

   /**
   * 协同方税号
   * @return cooperatorTaxNo
  **/
  @ApiModelProperty(value = "协同方税号")
  public String getCooperatorTaxNo() {
    return cooperatorTaxNo;
  }

  public void setCooperatorTaxNo(String cooperatorTaxNo) {
    this.cooperatorTaxNo = cooperatorTaxNo;
  }

  @JsonIgnore
  public MsQueryGoodsListV2Request companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsQueryGoodsListV2Request tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsQueryGoodsListV2Request goodsName(String goodsName) {
    this.goodsName = goodsName;
    return this;
  }

   /**
   * 商品名称
   * @return goodsName
  **/
  @ApiModelProperty(value = "商品名称")
  public String getGoodsName() {
    return goodsName;
  }

  public void setGoodsName(String goodsName) {
    this.goodsName = goodsName;
  }

  @JsonIgnore
  public MsQueryGoodsListV2Request goodsNo(String goodsNo) {
    this.goodsNo = goodsNo;
    return this;
  }

   /**
   * 商品编码
   * @return goodsNo
  **/
  @ApiModelProperty(value = "商品编码")
  public String getGoodsNo() {
    return goodsNo;
  }

  public void setGoodsNo(String goodsNo) {
    this.goodsNo = goodsNo;
  }

  @JsonIgnore
  public MsQueryGoodsListV2Request returnType(Integer returnType) {
    this.returnType = returnType;
    return this;
  }

   /**
   * 返回类型
   * @return returnType
  **/
  @ApiModelProperty(value = "返回类型")
  public Integer getReturnType() {
    return returnType;
  }

  public void setReturnType(Integer returnType) {
    this.returnType = returnType;
  }

  @JsonIgnore
  public MsQueryGoodsListV2Request type(Integer type) {
    this.type = type;
    return this;
  }

   /**
   * 类型
   * @return type
  **/
  @ApiModelProperty(value = "类型")
  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  @JsonIgnore
  public MsQueryGoodsListV2Request pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页码数
   * @return pageNo
  **/
  @ApiModelProperty(value = "页码数")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsQueryGoodsListV2Request pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 页码大小
   * @return pageSize
  **/
  @ApiModelProperty(value = "页码大小")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsQueryGoodsListV2Request hasCooperator(Boolean hasCooperator) {
    this.hasCooperator = hasCooperator;
    return this;
  }

   /**
   * 是否包含协同
   * @return hasCooperator
  **/
  @ApiModelProperty(value = "是否包含协同")
  public Boolean getHasCooperator() {
    return hasCooperator;
  }

  public void setHasCooperator(Boolean hasCooperator) {
    this.hasCooperator = hasCooperator;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsQueryGoodsListV2Request queryGoodsListV2Request = (MsQueryGoodsListV2Request) o;
    return Objects.equals(this.cooperatorGoodsNo, queryGoodsListV2Request.cooperatorGoodsNo) &&
        Objects.equals(this.cooperatorTenantId, queryGoodsListV2Request.cooperatorTenantId) &&
        Objects.equals(this.cooperatorTaxNo, queryGoodsListV2Request.cooperatorTaxNo) &&
        Objects.equals(this.companyId, queryGoodsListV2Request.companyId) &&
        Objects.equals(this.tenantId, queryGoodsListV2Request.tenantId) &&
        Objects.equals(this.goodsName, queryGoodsListV2Request.goodsName) &&
        Objects.equals(this.goodsNo, queryGoodsListV2Request.goodsNo) &&
        Objects.equals(this.returnType, queryGoodsListV2Request.returnType) &&
        Objects.equals(this.type, queryGoodsListV2Request.type) &&
        Objects.equals(this.pageNo, queryGoodsListV2Request.pageNo) &&
        Objects.equals(this.pageSize, queryGoodsListV2Request.pageSize) &&
        Objects.equals(this.hasCooperator, queryGoodsListV2Request.hasCooperator);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cooperatorGoodsNo, cooperatorTenantId, cooperatorTaxNo, companyId, tenantId, goodsName, goodsNo, returnType, type, pageNo, pageSize, hasCooperator);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsQueryGoodsListV2Request {\n");
    
    sb.append("    cooperatorGoodsNo: ").append(toIndentedString(cooperatorGoodsNo)).append("\n");
    sb.append("    cooperatorTenantId: ").append(toIndentedString(cooperatorTenantId)).append("\n");
    sb.append("    cooperatorTaxNo: ").append(toIndentedString(cooperatorTaxNo)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    goodsName: ").append(toIndentedString(goodsName)).append("\n");
    sb.append("    goodsNo: ").append(toIndentedString(goodsNo)).append("\n");
    sb.append("    returnType: ").append(toIndentedString(returnType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    hasCooperator: ").append(toIndentedString(hasCooperator)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
