package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 基础配置保存请求
 */
@ApiModel(description = "基础配置保存请求")

@JsonInclude(NON_NULL)
public class MsSaveBaseSettingRequest {
  @JsonProperty("purTenantId")
  private Long purTenantId = null;

  @JsonProperty("purTenantCode")
  private String purTenantCode = null;

  @JsonProperty("purTenantName")
  private String purTenantName = null;

  @JsonIgnore
  public MsSaveBaseSettingRequest purTenantId(Long purTenantId) {
    this.purTenantId = purTenantId;
    return this;
  }

   /**
   * 购方租户ID
   * @return purTenantId
  **/
  @ApiModelProperty(value = "购方租户ID")
  public Long getPurTenantId() {
    return purTenantId;
  }

  public void setPurTenantId(Long purTenantId) {
    this.purTenantId = purTenantId;
  }

  @JsonIgnore
  public MsSaveBaseSettingRequest purTenantCode(String purTenantCode) {
    this.purTenantCode = purTenantCode;
    return this;
  }

   /**
   * 购方租户CODE
   * @return purTenantCode
  **/
  @ApiModelProperty(value = "购方租户CODE")
  public String getPurTenantCode() {
    return purTenantCode;
  }

  public void setPurTenantCode(String purTenantCode) {
    this.purTenantCode = purTenantCode;
  }

  @JsonIgnore
  public MsSaveBaseSettingRequest purTenantName(String purTenantName) {
    this.purTenantName = purTenantName;
    return this;
  }

   /**
   * 购方租户名称
   * @return purTenantName
  **/
  @ApiModelProperty(value = "购方租户名称")
  public String getPurTenantName() {
    return purTenantName;
  }

  public void setPurTenantName(String purTenantName) {
    this.purTenantName = purTenantName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSaveBaseSettingRequest saveBaseSettingRequest = (MsSaveBaseSettingRequest) o;
    return Objects.equals(this.purTenantId, saveBaseSettingRequest.purTenantId) &&
        Objects.equals(this.purTenantCode, saveBaseSettingRequest.purTenantCode) &&
        Objects.equals(this.purTenantName, saveBaseSettingRequest.purTenantName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(purTenantId, purTenantCode, purTenantName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSaveBaseSettingRequest {\n");
    
    sb.append("    purTenantId: ").append(toIndentedString(purTenantId)).append("\n");
    sb.append("    purTenantCode: ").append(toIndentedString(purTenantCode)).append("\n");
    sb.append("    purTenantName: ").append(toIndentedString(purTenantName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
