package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsSqsMessageListenerRequest
 */

@JsonInclude(NON_NULL)
public class MsSqsMessageListenerRequest {
  @JsonProperty("header")
  private String header = null;

  @JsonProperty("body")
  private String body = null;

  @JsonProperty("queueName")
  private String queueName = null;

  @JsonIgnore
  public MsSqsMessageListenerRequest header(String header) {
    this.header = header;
    return this;
  }

   /**
   * 属性
   * @return header
  **/
  @ApiModelProperty(value = "属性")
  public String getHeader() {
    return header;
  }

  public void setHeader(String header) {
    this.header = header;
  }

  @JsonIgnore
  public MsSqsMessageListenerRequest body(String body) {
    this.body = body;
    return this;
  }

   /**
   * 消息体
   * @return body
  **/
  @ApiModelProperty(value = "消息体")
  public String getBody() {
    return body;
  }

  public void setBody(String body) {
    this.body = body;
  }

  @JsonIgnore
  public MsSqsMessageListenerRequest queueName(String queueName) {
    this.queueName = queueName;
    return this;
  }

   /**
   * 队列名
   * @return queueName
  **/
  @ApiModelProperty(value = "队列名")
  public String getQueueName() {
    return queueName;
  }

  public void setQueueName(String queueName) {
    this.queueName = queueName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSqsMessageListenerRequest sqsMessageListenerRequest = (MsSqsMessageListenerRequest) o;
    return Objects.equals(this.header, sqsMessageListenerRequest.header) &&
        Objects.equals(this.body, sqsMessageListenerRequest.body) &&
        Objects.equals(this.queueName, sqsMessageListenerRequest.queueName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(header, body, queueName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSqsMessageListenerRequest {\n");
    
    sb.append("    header: ").append(toIndentedString(header)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    queueName: ").append(toIndentedString(queueName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
