package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 意见添加请求
 */
@ApiModel(description = "意见添加请求")

@JsonInclude(NON_NULL)
public class MsSuggestAddRequest {
  @JsonProperty("suggest")
  private String suggest = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonIgnore
  public MsSuggestAddRequest suggest(String suggest) {
    this.suggest = suggest;
    return this;
  }

   /**
   * 意见内容
   * @return suggest
  **/
  @ApiModelProperty(value = "意见内容")
  public String getSuggest() {
    return suggest;
  }

  public void setSuggest(String suggest) {
    this.suggest = suggest;
  }

  @JsonIgnore
  public MsSuggestAddRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSuggestAddRequest suggestAddRequest = (MsSuggestAddRequest) o;
    return Objects.equals(this.suggest, suggestAddRequest.suggest) &&
        Objects.equals(this.userId, suggestAddRequest.userId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(suggest, userId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSuggestAddRequest {\n");
    
    sb.append("    suggest: ").append(toIndentedString(suggest)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
