package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 帮助消息model
 */
@ApiModel(description = "帮助消息model")

@JsonInclude(NON_NULL)
public class MsSupportModel {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("productionLine")
  private String productionLine = null;

  @JsonProperty("userGroup")
  private Integer userGroup = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("groupName")
  private String groupName = null;

  @JsonProperty("serviceType")
  private Integer serviceType = null;

  @JsonProperty("menuPid")
  private Long menuPid = null;

  @JsonProperty("menuPidDisplayName")
  private String menuPidDisplayName = null;

  @JsonProperty("menuId")
  private Long menuId = null;

  @JsonProperty("menuIdDisplayName")
  private String menuIdDisplayName = null;

  @JsonProperty("errorCode")
  private String errorCode = null;

  @JsonProperty("keyword")
  private String keyword = null;

  @JsonProperty("title")
  private String title = null;

  @JsonProperty("content")
  private String content = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("opTenantId")
  private Long opTenantId = null;

  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonIgnore
  public MsSupportModel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * modelId
   * @return id
  **/
  @ApiModelProperty(value = "modelId")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsSupportModel productionLine(String productionLine) {
    this.productionLine = productionLine;
    return this;
  }

   /**
   * 所属产线
   * @return productionLine
  **/
  @ApiModelProperty(value = "所属产线")
  public String getProductionLine() {
    return productionLine;
  }

  public void setProductionLine(String productionLine) {
    this.productionLine = productionLine;
  }

  @JsonIgnore
  public MsSupportModel userGroup(Integer userGroup) {
    this.userGroup = userGroup;
    return this;
  }

   /**
   * 作用范围 1-所有用户 2-特定购方
   * @return userGroup
  **/
  @ApiModelProperty(value = "作用范围 1-所有用户 2-特定购方")
  public Integer getUserGroup() {
    return userGroup;
  }

  public void setUserGroup(Integer userGroup) {
    this.userGroup = userGroup;
  }

  @JsonIgnore
  public MsSupportModel groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 购方租户id
   * @return groupId
  **/
  @ApiModelProperty(value = "购方租户id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsSupportModel groupName(String groupName) {
    this.groupName = groupName;
    return this;
  }

   /**
   * 购方租户名称
   * @return groupName
  **/
  @ApiModelProperty(value = "购方租户名称")
  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  @JsonIgnore
  public MsSupportModel serviceType(Integer serviceType) {
    this.serviceType = serviceType;
    return this;
  }

   /**
   * 服务类型 0-所有服务 1-直连服务 2-非直连服务
   * @return serviceType
  **/
  @ApiModelProperty(value = "服务类型 0-所有服务 1-直连服务 2-非直连服务")
  public Integer getServiceType() {
    return serviceType;
  }

  public void setServiceType(Integer serviceType) {
    this.serviceType = serviceType;
  }

  @JsonIgnore
  public MsSupportModel menuPid(Long menuPid) {
    this.menuPid = menuPid;
    return this;
  }

   /**
   * 所属父菜单 0-最上级菜单
   * @return menuPid
  **/
  @ApiModelProperty(value = "所属父菜单 0-最上级菜单")
  public Long getMenuPid() {
    return menuPid;
  }

  public void setMenuPid(Long menuPid) {
    this.menuPid = menuPid;
  }

  @JsonIgnore
  public MsSupportModel menuPidDisplayName(String menuPidDisplayName) {
    this.menuPidDisplayName = menuPidDisplayName;
    return this;
  }

   /**
   * 父菜单显示
   * @return menuPidDisplayName
  **/
  @ApiModelProperty(value = "父菜单显示")
  public String getMenuPidDisplayName() {
    return menuPidDisplayName;
  }

  public void setMenuPidDisplayName(String menuPidDisplayName) {
    this.menuPidDisplayName = menuPidDisplayName;
  }

  @JsonIgnore
  public MsSupportModel menuId(Long menuId) {
    this.menuId = menuId;
    return this;
  }

   /**
   * 所属菜单id
   * @return menuId
  **/
  @ApiModelProperty(value = "所属菜单id")
  public Long getMenuId() {
    return menuId;
  }

  public void setMenuId(Long menuId) {
    this.menuId = menuId;
  }

  @JsonIgnore
  public MsSupportModel menuIdDisplayName(String menuIdDisplayName) {
    this.menuIdDisplayName = menuIdDisplayName;
    return this;
  }

   /**
   * 菜单显示
   * @return menuIdDisplayName
  **/
  @ApiModelProperty(value = "菜单显示")
  public String getMenuIdDisplayName() {
    return menuIdDisplayName;
  }

  public void setMenuIdDisplayName(String menuIdDisplayName) {
    this.menuIdDisplayName = menuIdDisplayName;
  }

  @JsonIgnore
  public MsSupportModel errorCode(String errorCode) {
    this.errorCode = errorCode;
    return this;
  }

   /**
   * 相关联错误代码集合 错误码id 多个逗号隔开
   * @return errorCode
  **/
  @ApiModelProperty(value = "相关联错误代码集合 错误码id 多个逗号隔开")
  public String getErrorCode() {
    return errorCode;
  }

  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }

  @JsonIgnore
  public MsSupportModel keyword(String keyword) {
    this.keyword = keyword;
    return this;
  }

   /**
   * 关键词 多个逗号隔开
   * @return keyword
  **/
  @ApiModelProperty(value = "关键词 多个逗号隔开")
  public String getKeyword() {
    return keyword;
  }

  public void setKeyword(String keyword) {
    this.keyword = keyword;
  }

  @JsonIgnore
  public MsSupportModel title(String title) {
    this.title = title;
    return this;
  }

   /**
   * 主题
   * @return title
  **/
  @ApiModelProperty(value = "主题")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  @JsonIgnore
  public MsSupportModel content(String content) {
    this.content = content;
    return this;
  }

   /**
   * 正文
   * @return content
  **/
  @ApiModelProperty(value = "正文")
  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  @JsonIgnore
  public MsSupportModel status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态
   * @return status
  **/
  @ApiModelProperty(value = "状态")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsSupportModel opTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
    return this;
  }

   /**
   * 操作用户所属租户id
   * @return opTenantId
  **/
  @ApiModelProperty(value = "操作用户所属租户id")
  public Long getOpTenantId() {
    return opTenantId;
  }

  public void setOpTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
  }

  @JsonIgnore
  public MsSupportModel opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作用户id
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作用户id")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsSupportModel opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作用户名称
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作用户名称")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSupportModel supportModel = (MsSupportModel) o;
    return Objects.equals(this.id, supportModel.id) &&
        Objects.equals(this.productionLine, supportModel.productionLine) &&
        Objects.equals(this.userGroup, supportModel.userGroup) &&
        Objects.equals(this.groupId, supportModel.groupId) &&
        Objects.equals(this.groupName, supportModel.groupName) &&
        Objects.equals(this.serviceType, supportModel.serviceType) &&
        Objects.equals(this.menuPid, supportModel.menuPid) &&
        Objects.equals(this.menuPidDisplayName, supportModel.menuPidDisplayName) &&
        Objects.equals(this.menuId, supportModel.menuId) &&
        Objects.equals(this.menuIdDisplayName, supportModel.menuIdDisplayName) &&
        Objects.equals(this.errorCode, supportModel.errorCode) &&
        Objects.equals(this.keyword, supportModel.keyword) &&
        Objects.equals(this.title, supportModel.title) &&
        Objects.equals(this.content, supportModel.content) &&
        Objects.equals(this.status, supportModel.status) &&
        Objects.equals(this.opTenantId, supportModel.opTenantId) &&
        Objects.equals(this.opUserId, supportModel.opUserId) &&
        Objects.equals(this.opUserName, supportModel.opUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, productionLine, userGroup, groupId, groupName, serviceType, menuPid, menuPidDisplayName, menuId, menuIdDisplayName, errorCode, keyword, title, content, status, opTenantId, opUserId, opUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSupportModel {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    productionLine: ").append(toIndentedString(productionLine)).append("\n");
    sb.append("    userGroup: ").append(toIndentedString(userGroup)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
    sb.append("    serviceType: ").append(toIndentedString(serviceType)).append("\n");
    sb.append("    menuPid: ").append(toIndentedString(menuPid)).append("\n");
    sb.append("    menuPidDisplayName: ").append(toIndentedString(menuPidDisplayName)).append("\n");
    sb.append("    menuId: ").append(toIndentedString(menuId)).append("\n");
    sb.append("    menuIdDisplayName: ").append(toIndentedString(menuIdDisplayName)).append("\n");
    sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
    sb.append("    keyword: ").append(toIndentedString(keyword)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    opTenantId: ").append(toIndentedString(opTenantId)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
