package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTCCoopBean
 */

@JsonInclude(NON_NULL)
public class MsTCCoopBean {
  @JsonProperty("coopSyncFlag")
  private String coopSyncFlag = null;

  @JsonProperty("coopRuleFlag")
  private String coopRuleFlag = null;

  @JsonProperty("coopRuleInvoiceTypeList")
  private List<String> coopRuleInvoiceTypeList = new ArrayList<String>();

  @JsonProperty("oneStopId")
  private Long oneStopId = null;

  @JsonProperty("coopType")
  private String coopType = null;

  @JsonProperty("purchaserTenantCode")
  private String purchaserTenantCode = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("sellerTenantCode")
  private String sellerTenantCode = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonIgnore
  public MsTCCoopBean coopSyncFlag(String coopSyncFlag) {
    this.coopSyncFlag = coopSyncFlag;
    return this;
  }

   /**
   * 协同同步集成标记 Y-同步（默认） N-不同步
   * @return coopSyncFlag
  **/
  @ApiModelProperty(value = "协同同步集成标记 Y-同步（默认） N-不同步")
  public String getCoopSyncFlag() {
    return coopSyncFlag;
  }

  public void setCoopSyncFlag(String coopSyncFlag) {
    this.coopSyncFlag = coopSyncFlag;
  }

  @JsonIgnore
  public MsTCCoopBean coopRuleFlag(String coopRuleFlag) {
    this.coopRuleFlag = coopRuleFlag;
    return this;
  }

   /**
   * 协同规则创建标记 Y-创建（默认） N-不创建
   * @return coopRuleFlag
  **/
  @ApiModelProperty(value = "协同规则创建标记 Y-创建（默认） N-不创建")
  public String getCoopRuleFlag() {
    return coopRuleFlag;
  }

  public void setCoopRuleFlag(String coopRuleFlag) {
    this.coopRuleFlag = coopRuleFlag;
  }

  @JsonIgnore
  public MsTCCoopBean coopRuleInvoiceTypeList(List<String> coopRuleInvoiceTypeList) {
    this.coopRuleInvoiceTypeList = coopRuleInvoiceTypeList;
    return this;
  }

  public MsTCCoopBean addCoopRuleInvoiceTypeListItem(String coopRuleInvoiceTypeListItem) {
    this.coopRuleInvoiceTypeList.add(coopRuleInvoiceTypeListItem);
    return this;
  }

   /**
   * 协同规则发票类型列表
   * @return coopRuleInvoiceTypeList
  **/
  @ApiModelProperty(value = "协同规则发票类型列表")
  public List<String> getCoopRuleInvoiceTypeList() {
    return coopRuleInvoiceTypeList;
  }

  public void setCoopRuleInvoiceTypeList(List<String> coopRuleInvoiceTypeList) {
    this.coopRuleInvoiceTypeList = coopRuleInvoiceTypeList;
  }

  @JsonIgnore
  public MsTCCoopBean oneStopId(Long oneStopId) {
    this.oneStopId = oneStopId;
    return this;
  }

   /**
   * 一站式入驻ID
   * @return oneStopId
  **/
  @ApiModelProperty(value = "一站式入驻ID")
  public Long getOneStopId() {
    return oneStopId;
  }

  public void setOneStopId(Long oneStopId) {
    this.oneStopId = oneStopId;
  }

  @JsonIgnore
  public MsTCCoopBean coopType(String coopType) {
    this.coopType = coopType;
    return this;
  }

   /**
   * 协同类型 G-购方集团与销方集团协同 X-购方集团与销方公司协同  Y-销方集团与购方公司协同
   * @return coopType
  **/
  @ApiModelProperty(value = "协同类型 G-购方集团与销方集团协同 X-购方集团与销方公司协同  Y-销方集团与购方公司协同")
  public String getCoopType() {
    return coopType;
  }

  public void setCoopType(String coopType) {
    this.coopType = coopType;
  }

  @JsonIgnore
  public MsTCCoopBean purchaserTenantCode(String purchaserTenantCode) {
    this.purchaserTenantCode = purchaserTenantCode;
    return this;
  }

   /**
   * 协同购方租户代码
   * @return purchaserTenantCode
  **/
  @ApiModelProperty(value = "协同购方租户代码")
  public String getPurchaserTenantCode() {
    return purchaserTenantCode;
  }

  public void setPurchaserTenantCode(String purchaserTenantCode) {
    this.purchaserTenantCode = purchaserTenantCode;
  }

  @JsonIgnore
  public MsTCCoopBean purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 协同购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "协同购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsTCCoopBean sellerTenantCode(String sellerTenantCode) {
    this.sellerTenantCode = sellerTenantCode;
    return this;
  }

   /**
   * 协同销方租户代码
   * @return sellerTenantCode
  **/
  @ApiModelProperty(value = "协同销方租户代码")
  public String getSellerTenantCode() {
    return sellerTenantCode;
  }

  public void setSellerTenantCode(String sellerTenantCode) {
    this.sellerTenantCode = sellerTenantCode;
  }

  @JsonIgnore
  public MsTCCoopBean sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 协同销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "协同销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCCoopBean tcCoopBean = (MsTCCoopBean) o;
    return Objects.equals(this.coopSyncFlag, tcCoopBean.coopSyncFlag) &&
        Objects.equals(this.coopRuleFlag, tcCoopBean.coopRuleFlag) &&
        Objects.equals(this.coopRuleInvoiceTypeList, tcCoopBean.coopRuleInvoiceTypeList) &&
        Objects.equals(this.oneStopId, tcCoopBean.oneStopId) &&
        Objects.equals(this.coopType, tcCoopBean.coopType) &&
        Objects.equals(this.purchaserTenantCode, tcCoopBean.purchaserTenantCode) &&
        Objects.equals(this.purchaserTaxNo, tcCoopBean.purchaserTaxNo) &&
        Objects.equals(this.sellerTenantCode, tcCoopBean.sellerTenantCode) &&
        Objects.equals(this.sellerTaxNo, tcCoopBean.sellerTaxNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(coopSyncFlag, coopRuleFlag, coopRuleInvoiceTypeList, oneStopId, coopType, purchaserTenantCode, purchaserTaxNo, sellerTenantCode, sellerTaxNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCCoopBean {\n");
    
    sb.append("    coopSyncFlag: ").append(toIndentedString(coopSyncFlag)).append("\n");
    sb.append("    coopRuleFlag: ").append(toIndentedString(coopRuleFlag)).append("\n");
    sb.append("    coopRuleInvoiceTypeList: ").append(toIndentedString(coopRuleInvoiceTypeList)).append("\n");
    sb.append("    oneStopId: ").append(toIndentedString(oneStopId)).append("\n");
    sb.append("    coopType: ").append(toIndentedString(coopType)).append("\n");
    sb.append("    purchaserTenantCode: ").append(toIndentedString(purchaserTenantCode)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    sellerTenantCode: ").append(toIndentedString(sellerTenantCode)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
