package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTCQueryAccountByTaxNoResponse
 */

@JsonInclude(NON_NULL)
public class MsTCQueryAccountByTaxNoResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("loginPhoneList")
  private List<String> loginPhoneList = new ArrayList<String>();

  @JsonProperty("loginEmailList")
  private List<String> loginEmailList = new ArrayList<String>();

  @JsonIgnore
  public MsTCQueryAccountByTaxNoResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsTCQueryAccountByTaxNoResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsTCQueryAccountByTaxNoResponse loginPhoneList(List<String> loginPhoneList) {
    this.loginPhoneList = loginPhoneList;
    return this;
  }

  public MsTCQueryAccountByTaxNoResponse addLoginPhoneListItem(String loginPhoneListItem) {
    this.loginPhoneList.add(loginPhoneListItem);
    return this;
  }

   /**
   * 手机账号列表
   * @return loginPhoneList
  **/
  @ApiModelProperty(value = "手机账号列表")
  public List<String> getLoginPhoneList() {
    return loginPhoneList;
  }

  public void setLoginPhoneList(List<String> loginPhoneList) {
    this.loginPhoneList = loginPhoneList;
  }

  @JsonIgnore
  public MsTCQueryAccountByTaxNoResponse loginEmailList(List<String> loginEmailList) {
    this.loginEmailList = loginEmailList;
    return this;
  }

  public MsTCQueryAccountByTaxNoResponse addLoginEmailListItem(String loginEmailListItem) {
    this.loginEmailList.add(loginEmailListItem);
    return this;
  }

   /**
   * 邮箱账号列表
   * @return loginEmailList
  **/
  @ApiModelProperty(value = "邮箱账号列表")
  public List<String> getLoginEmailList() {
    return loginEmailList;
  }

  public void setLoginEmailList(List<String> loginEmailList) {
    this.loginEmailList = loginEmailList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCQueryAccountByTaxNoResponse tcQueryAccountByTaxNoResponse = (MsTCQueryAccountByTaxNoResponse) o;
    return Objects.equals(this.code, tcQueryAccountByTaxNoResponse.code) &&
        Objects.equals(this.message, tcQueryAccountByTaxNoResponse.message) &&
        Objects.equals(this.loginPhoneList, tcQueryAccountByTaxNoResponse.loginPhoneList) &&
        Objects.equals(this.loginEmailList, tcQueryAccountByTaxNoResponse.loginEmailList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, loginPhoneList, loginEmailList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCQueryAccountByTaxNoResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    loginPhoneList: ").append(toIndentedString(loginPhoneList)).append("\n");
    sb.append("    loginEmailList: ").append(toIndentedString(loginEmailList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
