package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取租户公司列表
 */
@ApiModel(description = "获取租户公司列表")

@JsonInclude(NON_NULL)
public class MsTCQueryTenantCompanyRequest {
  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("tenantCode")
  private String tenantCode = null;

  @JsonProperty("pageNo")
  private Integer pageNo = 1;

  @JsonProperty("pageSize")
  private Integer pageSize = 10;

  @JsonIgnore
  public MsTCQueryTenantCompanyRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsTCQueryTenantCompanyRequest tenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
    return this;
  }

   /**
   * 租户代码
   * @return tenantCode
  **/
  @ApiModelProperty(value = "租户代码")
  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  @JsonIgnore
  public MsTCQueryTenantCompanyRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 当前页数
   * @return pageNo
  **/
  @ApiModelProperty(value = "当前页数")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsTCQueryTenantCompanyRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCQueryTenantCompanyRequest tcQueryTenantCompanyRequest = (MsTCQueryTenantCompanyRequest) o;
    return Objects.equals(this.tenantId, tcQueryTenantCompanyRequest.tenantId) &&
        Objects.equals(this.tenantCode, tcQueryTenantCompanyRequest.tenantCode) &&
        Objects.equals(this.pageNo, tcQueryTenantCompanyRequest.pageNo) &&
        Objects.equals(this.pageSize, tcQueryTenantCompanyRequest.pageSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, tenantCode, pageNo, pageSize);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCQueryTenantCompanyRequest {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    tenantCode: ").append(toIndentedString(tenantCode)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
