package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTCServicePackageBean
 */

@JsonInclude(NON_NULL)
public class MsTCServicePackageBean {
  @JsonProperty("servicePackageCode")
  private String servicePackageCode = null;

  @JsonProperty("serviceStartTime")
  private String serviceStartTime = null;

  @JsonProperty("serviceEndTime")
  private String serviceEndTime = null;

  @JsonIgnore
  public MsTCServicePackageBean servicePackageCode(String servicePackageCode) {
    this.servicePackageCode = servicePackageCode;
    return this;
  }

   /**
   * 服务包CODE (必填)
   * @return servicePackageCode
  **/
  @ApiModelProperty(value = "服务包CODE (必填)")
  public String getServicePackageCode() {
    return servicePackageCode;
  }

  public void setServicePackageCode(String servicePackageCode) {
    this.servicePackageCode = servicePackageCode;
  }

  @JsonIgnore
  public MsTCServicePackageBean serviceStartTime(String serviceStartTime) {
    this.serviceStartTime = serviceStartTime;
    return this;
  }

   /**
   * 服务有效期开始时间 格式：yyyyMMdd
   * @return serviceStartTime
  **/
  @ApiModelProperty(value = "服务有效期开始时间 格式：yyyyMMdd")
  public String getServiceStartTime() {
    return serviceStartTime;
  }

  public void setServiceStartTime(String serviceStartTime) {
    this.serviceStartTime = serviceStartTime;
  }

  @JsonIgnore
  public MsTCServicePackageBean serviceEndTime(String serviceEndTime) {
    this.serviceEndTime = serviceEndTime;
    return this;
  }

   /**
   * 服务有效期结束时间 格式：yyyyMMdd
   * @return serviceEndTime
  **/
  @ApiModelProperty(value = "服务有效期结束时间 格式：yyyyMMdd")
  public String getServiceEndTime() {
    return serviceEndTime;
  }

  public void setServiceEndTime(String serviceEndTime) {
    this.serviceEndTime = serviceEndTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCServicePackageBean tcServicePackageBean = (MsTCServicePackageBean) o;
    return Objects.equals(this.servicePackageCode, tcServicePackageBean.servicePackageCode) &&
        Objects.equals(this.serviceStartTime, tcServicePackageBean.serviceStartTime) &&
        Objects.equals(this.serviceEndTime, tcServicePackageBean.serviceEndTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(servicePackageCode, serviceStartTime, serviceEndTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCServicePackageBean {\n");
    
    sb.append("    servicePackageCode: ").append(toIndentedString(servicePackageCode)).append("\n");
    sb.append("    serviceStartTime: ").append(toIndentedString(serviceStartTime)).append("\n");
    sb.append("    serviceEndTime: ").append(toIndentedString(serviceEndTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
