package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTCTenantBean
 */

@JsonInclude(NON_NULL)
public class MsTCTenantBean {
  @JsonProperty("tenantCode")
  private String tenantCode = null;

  @JsonProperty("tenantName")
  private String tenantName = null;

  @JsonProperty("tenantEmail")
  private String tenantEmail = null;

  @JsonProperty("tenantPhone")
  private String tenantPhone = null;

  @JsonProperty("tenantPassword")
  private String tenantPassword = null;

  @JsonProperty("tenantRoleCodeList")
  private List<String> tenantRoleCodeList = new ArrayList<String>();

  @JsonIgnore
  public MsTCTenantBean tenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
    return this;
  }

   /**
   * 租户代码（全局唯一）
   * @return tenantCode
  **/
  @ApiModelProperty(value = "租户代码（全局唯一）")
  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  @JsonIgnore
  public MsTCTenantBean tenantName(String tenantName) {
    this.tenantName = tenantName;
    return this;
  }

   /**
   * 租户名称（可为公司名）
   * @return tenantName
  **/
  @ApiModelProperty(value = "租户名称（可为公司名）")
  public String getTenantName() {
    return tenantName;
  }

  public void setTenantName(String tenantName) {
    this.tenantName = tenantName;
  }

  @JsonIgnore
  public MsTCTenantBean tenantEmail(String tenantEmail) {
    this.tenantEmail = tenantEmail;
    return this;
  }

   /**
   * 租户邮箱(租户管理员登录账户)
   * @return tenantEmail
  **/
  @ApiModelProperty(value = "租户邮箱(租户管理员登录账户)")
  public String getTenantEmail() {
    return tenantEmail;
  }

  public void setTenantEmail(String tenantEmail) {
    this.tenantEmail = tenantEmail;
  }

  @JsonIgnore
  public MsTCTenantBean tenantPhone(String tenantPhone) {
    this.tenantPhone = tenantPhone;
    return this;
  }

   /**
   * 租户手机号
   * @return tenantPhone
  **/
  @ApiModelProperty(value = "租户手机号")
  public String getTenantPhone() {
    return tenantPhone;
  }

  public void setTenantPhone(String tenantPhone) {
    this.tenantPhone = tenantPhone;
  }

  @JsonIgnore
  public MsTCTenantBean tenantPassword(String tenantPassword) {
    this.tenantPassword = tenantPassword;
    return this;
  }

   /**
   * 租户登录密码(租户管理员登录密码),6-16位且区分大小写
   * @return tenantPassword
  **/
  @ApiModelProperty(value = "租户登录密码(租户管理员登录密码),6-16位且区分大小写")
  public String getTenantPassword() {
    return tenantPassword;
  }

  public void setTenantPassword(String tenantPassword) {
    this.tenantPassword = tenantPassword;
  }

  @JsonIgnore
  public MsTCTenantBean tenantRoleCodeList(List<String> tenantRoleCodeList) {
    this.tenantRoleCodeList = tenantRoleCodeList;
    return this;
  }

  public MsTCTenantBean addTenantRoleCodeListItem(String tenantRoleCodeListItem) {
    this.tenantRoleCodeList.add(tenantRoleCodeListItem);
    return this;
  }

   /**
   * 集团角色代码列表
   * @return tenantRoleCodeList
  **/
  @ApiModelProperty(value = "集团角色代码列表")
  public List<String> getTenantRoleCodeList() {
    return tenantRoleCodeList;
  }

  public void setTenantRoleCodeList(List<String> tenantRoleCodeList) {
    this.tenantRoleCodeList = tenantRoleCodeList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCTenantBean tcTenantBean = (MsTCTenantBean) o;
    return Objects.equals(this.tenantCode, tcTenantBean.tenantCode) &&
        Objects.equals(this.tenantName, tcTenantBean.tenantName) &&
        Objects.equals(this.tenantEmail, tcTenantBean.tenantEmail) &&
        Objects.equals(this.tenantPhone, tcTenantBean.tenantPhone) &&
        Objects.equals(this.tenantPassword, tcTenantBean.tenantPassword) &&
        Objects.equals(this.tenantRoleCodeList, tcTenantBean.tenantRoleCodeList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantCode, tenantName, tenantEmail, tenantPhone, tenantPassword, tenantRoleCodeList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCTenantBean {\n");
    
    sb.append("    tenantCode: ").append(toIndentedString(tenantCode)).append("\n");
    sb.append("    tenantName: ").append(toIndentedString(tenantName)).append("\n");
    sb.append("    tenantEmail: ").append(toIndentedString(tenantEmail)).append("\n");
    sb.append("    tenantPhone: ").append(toIndentedString(tenantPhone)).append("\n");
    sb.append("    tenantPassword: ").append(toIndentedString(tenantPassword)).append("\n");
    sb.append("    tenantRoleCodeList: ").append(toIndentedString(tenantRoleCodeList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
