package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsTCUserOrgDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTCUserAddRequest
 */

@JsonInclude(NON_NULL)
public class MsTCUserAddRequest {
  @JsonProperty("tenantId")
  private String tenantId = null;

  @JsonProperty("accountId")
  private String accountId = null;

  @JsonProperty("userCode")
  private String userCode = null;

  @JsonProperty("userPassword")
  private String userPassword = null;

  @JsonProperty("sendToUserFlag")
  private String sendToUserFlag = null;

  @JsonProperty("userNumber")
  private String userNumber = null;

  @JsonProperty("userName")
  private String userName = null;

  @JsonProperty("userPhone")
  private String userPhone = null;

  @JsonProperty("accountNum")
  private String accountNum = null;

  @JsonProperty("userSex")
  private String userSex = null;

  @JsonProperty("userEmailAddr")
  private String userEmailAddr = null;

  @JsonProperty("userIdCard")
  private String userIdCard = null;

  @JsonProperty("userPeriodTime")
  private String userPeriodTime = null;

  @JsonProperty("userWorkTel")
  private String userWorkTel = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("contactAddr")
  private String contactAddr = null;

  @JsonProperty("ticketOpeningTerminal")
  private String ticketOpeningTerminal = null;

  @JsonProperty("printingEquipment")
  private String printingEquipment = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("businessType")
  private String businessType = null;

  @JsonProperty("businessExtensionAttribute")
  private Object businessExtensionAttribute = null;

  @JsonProperty("opUserId")
  private String opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("roleId")
  private String roleId = null;

  @JsonProperty("userOrgDTOs")
  private List<MsTCUserOrgDTO> userOrgDTOs = new ArrayList<MsTCUserOrgDTO>();

  @JsonIgnore
  public MsTCUserAddRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsTCUserAddRequest accountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * 账号ID
   * @return accountId
  **/
  @ApiModelProperty(value = "账号ID")
  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  @JsonIgnore
  public MsTCUserAddRequest userCode(String userCode) {
    this.userCode = userCode;
    return this;
  }

   /**
   * 人员代码
   * @return userCode
  **/
  @ApiModelProperty(value = "人员代码")
  public String getUserCode() {
    return userCode;
  }

  public void setUserCode(String userCode) {
    this.userCode = userCode;
  }

  @JsonIgnore
  public MsTCUserAddRequest userPassword(String userPassword) {
    this.userPassword = userPassword;
    return this;
  }

   /**
   * 人员密码
   * @return userPassword
  **/
  @ApiModelProperty(value = "人员密码")
  public String getUserPassword() {
    return userPassword;
  }

  public void setUserPassword(String userPassword) {
    this.userPassword = userPassword;
  }

  @JsonIgnore
  public MsTCUserAddRequest sendToUserFlag(String sendToUserFlag) {
    this.sendToUserFlag = sendToUserFlag;
    return this;
  }

   /**
   * 用户消息发送标记  N-不发送  Y-发送（默认）
   * @return sendToUserFlag
  **/
  @ApiModelProperty(value = "用户消息发送标记  N-不发送  Y-发送（默认）")
  public String getSendToUserFlag() {
    return sendToUserFlag;
  }

  public void setSendToUserFlag(String sendToUserFlag) {
    this.sendToUserFlag = sendToUserFlag;
  }

  @JsonIgnore
  public MsTCUserAddRequest userNumber(String userNumber) {
    this.userNumber = userNumber;
    return this;
  }

   /**
   * 人员工号
   * @return userNumber
  **/
  @ApiModelProperty(value = "人员工号")
  public String getUserNumber() {
    return userNumber;
  }

  public void setUserNumber(String userNumber) {
    this.userNumber = userNumber;
  }

  @JsonIgnore
  public MsTCUserAddRequest userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * 人员姓名
   * @return userName
  **/
  @ApiModelProperty(value = "人员姓名")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  @JsonIgnore
  public MsTCUserAddRequest userPhone(String userPhone) {
    this.userPhone = userPhone;
    return this;
  }

   /**
   * 手机号码
   * @return userPhone
  **/
  @ApiModelProperty(value = "手机号码")
  public String getUserPhone() {
    return userPhone;
  }

  public void setUserPhone(String userPhone) {
    this.userPhone = userPhone;
  }

  @JsonIgnore
  public MsTCUserAddRequest accountNum(String accountNum) {
    this.accountNum = accountNum;
    return this;
  }

   /**
   * 用户账号
   * @return accountNum
  **/
  @ApiModelProperty(value = "用户账号")
  public String getAccountNum() {
    return accountNum;
  }

  public void setAccountNum(String accountNum) {
    this.accountNum = accountNum;
  }

  @JsonIgnore
  public MsTCUserAddRequest userSex(String userSex) {
    this.userSex = userSex;
    return this;
  }

   /**
   * 人员性别 0：男 1：女
   * @return userSex
  **/
  @ApiModelProperty(value = "人员性别 0：男 1：女")
  public String getUserSex() {
    return userSex;
  }

  public void setUserSex(String userSex) {
    this.userSex = userSex;
  }

  @JsonIgnore
  public MsTCUserAddRequest userEmailAddr(String userEmailAddr) {
    this.userEmailAddr = userEmailAddr;
    return this;
  }

   /**
   * 邮箱地址
   * @return userEmailAddr
  **/
  @ApiModelProperty(value = "邮箱地址")
  public String getUserEmailAddr() {
    return userEmailAddr;
  }

  public void setUserEmailAddr(String userEmailAddr) {
    this.userEmailAddr = userEmailAddr;
  }

  @JsonIgnore
  public MsTCUserAddRequest userIdCard(String userIdCard) {
    this.userIdCard = userIdCard;
    return this;
  }

   /**
   * 身份证号码
   * @return userIdCard
  **/
  @ApiModelProperty(value = "身份证号码")
  public String getUserIdCard() {
    return userIdCard;
  }

  public void setUserIdCard(String userIdCard) {
    this.userIdCard = userIdCard;
  }

  @JsonIgnore
  public MsTCUserAddRequest userPeriodTime(String userPeriodTime) {
    this.userPeriodTime = userPeriodTime;
    return this;
  }

   /**
   * 有效期
   * @return userPeriodTime
  **/
  @ApiModelProperty(value = "有效期")
  public String getUserPeriodTime() {
    return userPeriodTime;
  }

  public void setUserPeriodTime(String userPeriodTime) {
    this.userPeriodTime = userPeriodTime;
  }

  @JsonIgnore
  public MsTCUserAddRequest userWorkTel(String userWorkTel) {
    this.userWorkTel = userWorkTel;
    return this;
  }

   /**
   * 办公电话
   * @return userWorkTel
  **/
  @ApiModelProperty(value = "办公电话")
  public String getUserWorkTel() {
    return userWorkTel;
  }

  public void setUserWorkTel(String userWorkTel) {
    this.userWorkTel = userWorkTel;
  }

  @JsonIgnore
  public MsTCUserAddRequest status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 状态 1：启用  0：停用
   * @return status
  **/
  @ApiModelProperty(value = "状态 1：启用  0：停用")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public MsTCUserAddRequest contactAddr(String contactAddr) {
    this.contactAddr = contactAddr;
    return this;
  }

   /**
   * 联系地址
   * @return contactAddr
  **/
  @ApiModelProperty(value = "联系地址")
  public String getContactAddr() {
    return contactAddr;
  }

  public void setContactAddr(String contactAddr) {
    this.contactAddr = contactAddr;
  }

  @JsonIgnore
  public MsTCUserAddRequest ticketOpeningTerminal(String ticketOpeningTerminal) {
    this.ticketOpeningTerminal = ticketOpeningTerminal;
    return this;
  }

   /**
   * 开票终端  多个开票终端用\",\"分隔开
   * @return ticketOpeningTerminal
  **/
  @ApiModelProperty(value = "开票终端  多个开票终端用\",\"分隔开")
  public String getTicketOpeningTerminal() {
    return ticketOpeningTerminal;
  }

  public void setTicketOpeningTerminal(String ticketOpeningTerminal) {
    this.ticketOpeningTerminal = ticketOpeningTerminal;
  }

  @JsonIgnore
  public MsTCUserAddRequest printingEquipment(String printingEquipment) {
    this.printingEquipment = printingEquipment;
    return this;
  }

   /**
   * 打印设备  多个打印设备值用\",\"隔开
   * @return printingEquipment
  **/
  @ApiModelProperty(value = "打印设备  多个打印设备值用\",\"隔开")
  public String getPrintingEquipment() {
    return printingEquipment;
  }

  public void setPrintingEquipment(String printingEquipment) {
    this.printingEquipment = printingEquipment;
  }

  @JsonIgnore
  public MsTCUserAddRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型 c：普票；s：专票；cs：专票和普票 ce：普电票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型 c：普票；s：专票；cs：专票和普票 ce：普电票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsTCUserAddRequest businessType(String businessType) {
    this.businessType = businessType;
    return this;
  }

   /**
   * 业务类型
   * @return businessType
  **/
  @ApiModelProperty(value = "业务类型")
  public String getBusinessType() {
    return businessType;
  }

  public void setBusinessType(String businessType) {
    this.businessType = businessType;
  }

  @JsonIgnore
  public MsTCUserAddRequest businessExtensionAttribute(Object businessExtensionAttribute) {
    this.businessExtensionAttribute = businessExtensionAttribute;
    return this;
  }

   /**
   * 业务扩展属性
   * @return businessExtensionAttribute
  **/
  @ApiModelProperty(value = "业务扩展属性")
  public Object getBusinessExtensionAttribute() {
    return businessExtensionAttribute;
  }

  public void setBusinessExtensionAttribute(Object businessExtensionAttribute) {
    this.businessExtensionAttribute = businessExtensionAttribute;
  }

  @JsonIgnore
  public MsTCUserAddRequest opUserId(String opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public String getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(String opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsTCUserAddRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsTCUserAddRequest roleId(String roleId) {
    this.roleId = roleId;
    return this;
  }

   /**
   * 角色代码
   * @return roleId
  **/
  @ApiModelProperty(value = "角色代码")
  public String getRoleId() {
    return roleId;
  }

  public void setRoleId(String roleId) {
    this.roleId = roleId;
  }

  @JsonIgnore
  public MsTCUserAddRequest userOrgDTOs(List<MsTCUserOrgDTO> userOrgDTOs) {
    this.userOrgDTOs = userOrgDTOs;
    return this;
  }

  public MsTCUserAddRequest addUserOrgDTOsItem(MsTCUserOrgDTO userOrgDTOsItem) {
    this.userOrgDTOs.add(userOrgDTOsItem);
    return this;
  }

   /**
   * 用户组织
   * @return userOrgDTOs
  **/
  @ApiModelProperty(value = "用户组织")
  public List<MsTCUserOrgDTO> getUserOrgDTOs() {
    return userOrgDTOs;
  }

  public void setUserOrgDTOs(List<MsTCUserOrgDTO> userOrgDTOs) {
    this.userOrgDTOs = userOrgDTOs;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCUserAddRequest tcUserAddRequest = (MsTCUserAddRequest) o;
    return Objects.equals(this.tenantId, tcUserAddRequest.tenantId) &&
        Objects.equals(this.accountId, tcUserAddRequest.accountId) &&
        Objects.equals(this.userCode, tcUserAddRequest.userCode) &&
        Objects.equals(this.userPassword, tcUserAddRequest.userPassword) &&
        Objects.equals(this.sendToUserFlag, tcUserAddRequest.sendToUserFlag) &&
        Objects.equals(this.userNumber, tcUserAddRequest.userNumber) &&
        Objects.equals(this.userName, tcUserAddRequest.userName) &&
        Objects.equals(this.userPhone, tcUserAddRequest.userPhone) &&
        Objects.equals(this.accountNum, tcUserAddRequest.accountNum) &&
        Objects.equals(this.userSex, tcUserAddRequest.userSex) &&
        Objects.equals(this.userEmailAddr, tcUserAddRequest.userEmailAddr) &&
        Objects.equals(this.userIdCard, tcUserAddRequest.userIdCard) &&
        Objects.equals(this.userPeriodTime, tcUserAddRequest.userPeriodTime) &&
        Objects.equals(this.userWorkTel, tcUserAddRequest.userWorkTel) &&
        Objects.equals(this.status, tcUserAddRequest.status) &&
        Objects.equals(this.contactAddr, tcUserAddRequest.contactAddr) &&
        Objects.equals(this.ticketOpeningTerminal, tcUserAddRequest.ticketOpeningTerminal) &&
        Objects.equals(this.printingEquipment, tcUserAddRequest.printingEquipment) &&
        Objects.equals(this.invoiceType, tcUserAddRequest.invoiceType) &&
        Objects.equals(this.businessType, tcUserAddRequest.businessType) &&
        Objects.equals(this.businessExtensionAttribute, tcUserAddRequest.businessExtensionAttribute) &&
        Objects.equals(this.opUserId, tcUserAddRequest.opUserId) &&
        Objects.equals(this.opUserName, tcUserAddRequest.opUserName) &&
        Objects.equals(this.roleId, tcUserAddRequest.roleId) &&
        Objects.equals(this.userOrgDTOs, tcUserAddRequest.userOrgDTOs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, accountId, userCode, userPassword, sendToUserFlag, userNumber, userName, userPhone, accountNum, userSex, userEmailAddr, userIdCard, userPeriodTime, userWorkTel, status, contactAddr, ticketOpeningTerminal, printingEquipment, invoiceType, businessType, businessExtensionAttribute, opUserId, opUserName, roleId, userOrgDTOs);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCUserAddRequest {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    userCode: ").append(toIndentedString(userCode)).append("\n");
    sb.append("    userPassword: ").append(toIndentedString(userPassword)).append("\n");
    sb.append("    sendToUserFlag: ").append(toIndentedString(sendToUserFlag)).append("\n");
    sb.append("    userNumber: ").append(toIndentedString(userNumber)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    userPhone: ").append(toIndentedString(userPhone)).append("\n");
    sb.append("    accountNum: ").append(toIndentedString(accountNum)).append("\n");
    sb.append("    userSex: ").append(toIndentedString(userSex)).append("\n");
    sb.append("    userEmailAddr: ").append(toIndentedString(userEmailAddr)).append("\n");
    sb.append("    userIdCard: ").append(toIndentedString(userIdCard)).append("\n");
    sb.append("    userPeriodTime: ").append(toIndentedString(userPeriodTime)).append("\n");
    sb.append("    userWorkTel: ").append(toIndentedString(userWorkTel)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    contactAddr: ").append(toIndentedString(contactAddr)).append("\n");
    sb.append("    ticketOpeningTerminal: ").append(toIndentedString(ticketOpeningTerminal)).append("\n");
    sb.append("    printingEquipment: ").append(toIndentedString(printingEquipment)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    businessType: ").append(toIndentedString(businessType)).append("\n");
    sb.append("    businessExtensionAttribute: ").append(toIndentedString(businessExtensionAttribute)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    roleId: ").append(toIndentedString(roleId)).append("\n");
    sb.append("    userOrgDTOs: ").append(toIndentedString(userOrgDTOs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
