package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTCUserBean
 */

@JsonInclude(NON_NULL)
public class MsTCUserBean {
  @JsonProperty("userRoleCodeList")
  private List<String> userRoleCodeList = new ArrayList<String>();

  @JsonProperty("userOpenId")
  private String userOpenId = null;

  @JsonProperty("userEmail")
  private String userEmail = null;

  @JsonProperty("userPhone")
  private String userPhone = null;

  @JsonProperty("userName")
  private String userName = null;

  @JsonProperty("userAccount")
  private String userAccount = null;

  @JsonProperty("userPassword")
  private String userPassword = null;

  @JsonProperty("sendToUserFlag")
  private String sendToUserFlag = null;

  @JsonIgnore
  public MsTCUserBean userRoleCodeList(List<String> userRoleCodeList) {
    this.userRoleCodeList = userRoleCodeList;
    return this;
  }

  public MsTCUserBean addUserRoleCodeListItem(String userRoleCodeListItem) {
    this.userRoleCodeList.add(userRoleCodeListItem);
    return this;
  }

   /**
   * 用户角色代码列表
   * @return userRoleCodeList
  **/
  @ApiModelProperty(value = "用户角色代码列表")
  public List<String> getUserRoleCodeList() {
    return userRoleCodeList;
  }

  public void setUserRoleCodeList(List<String> userRoleCodeList) {
    this.userRoleCodeList = userRoleCodeList;
  }

  @JsonIgnore
  public MsTCUserBean userOpenId(String userOpenId) {
    this.userOpenId = userOpenId;
    return this;
  }

   /**
   * 用户公众号OPENID
   * @return userOpenId
  **/
  @ApiModelProperty(value = "用户公众号OPENID")
  public String getUserOpenId() {
    return userOpenId;
  }

  public void setUserOpenId(String userOpenId) {
    this.userOpenId = userOpenId;
  }

  @JsonIgnore
  public MsTCUserBean userEmail(String userEmail) {
    this.userEmail = userEmail;
    return this;
  }

   /**
   * 用户邮箱(可与租户邮箱相同)
   * @return userEmail
  **/
  @ApiModelProperty(value = "用户邮箱(可与租户邮箱相同)")
  public String getUserEmail() {
    return userEmail;
  }

  public void setUserEmail(String userEmail) {
    this.userEmail = userEmail;
  }

  @JsonIgnore
  public MsTCUserBean userPhone(String userPhone) {
    this.userPhone = userPhone;
    return this;
  }

   /**
   * 用户手机号(可与租户手机号相同)
   * @return userPhone
  **/
  @ApiModelProperty(value = "用户手机号(可与租户手机号相同)")
  public String getUserPhone() {
    return userPhone;
  }

  public void setUserPhone(String userPhone) {
    this.userPhone = userPhone;
  }

  @JsonIgnore
  public MsTCUserBean userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * 用户名
   * @return userName
  **/
  @ApiModelProperty(value = "用户名")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  @JsonIgnore
  public MsTCUserBean userAccount(String userAccount) {
    this.userAccount = userAccount;
    return this;
  }

   /**
   * 用户账号
   * @return userAccount
  **/
  @ApiModelProperty(value = "用户账号")
  public String getUserAccount() {
    return userAccount;
  }

  public void setUserAccount(String userAccount) {
    this.userAccount = userAccount;
  }

  @JsonIgnore
  public MsTCUserBean userPassword(String userPassword) {
    this.userPassword = userPassword;
    return this;
  }

   /**
   * 登录密码(单点登录密码),6-16位且区分大小写
   * @return userPassword
  **/
  @ApiModelProperty(value = "登录密码(单点登录密码),6-16位且区分大小写")
  public String getUserPassword() {
    return userPassword;
  }

  public void setUserPassword(String userPassword) {
    this.userPassword = userPassword;
  }

  @JsonIgnore
  public MsTCUserBean sendToUserFlag(String sendToUserFlag) {
    this.sendToUserFlag = sendToUserFlag;
    return this;
  }

   /**
   * 用户消息发送标记  N-不发送  Y-发送（默认）
   * @return sendToUserFlag
  **/
  @ApiModelProperty(value = "用户消息发送标记  N-不发送  Y-发送（默认）")
  public String getSendToUserFlag() {
    return sendToUserFlag;
  }

  public void setSendToUserFlag(String sendToUserFlag) {
    this.sendToUserFlag = sendToUserFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCUserBean tcUserBean = (MsTCUserBean) o;
    return Objects.equals(this.userRoleCodeList, tcUserBean.userRoleCodeList) &&
        Objects.equals(this.userOpenId, tcUserBean.userOpenId) &&
        Objects.equals(this.userEmail, tcUserBean.userEmail) &&
        Objects.equals(this.userPhone, tcUserBean.userPhone) &&
        Objects.equals(this.userName, tcUserBean.userName) &&
        Objects.equals(this.userAccount, tcUserBean.userAccount) &&
        Objects.equals(this.userPassword, tcUserBean.userPassword) &&
        Objects.equals(this.sendToUserFlag, tcUserBean.sendToUserFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userRoleCodeList, userOpenId, userEmail, userPhone, userName, userAccount, userPassword, sendToUserFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCUserBean {\n");
    
    sb.append("    userRoleCodeList: ").append(toIndentedString(userRoleCodeList)).append("\n");
    sb.append("    userOpenId: ").append(toIndentedString(userOpenId)).append("\n");
    sb.append("    userEmail: ").append(toIndentedString(userEmail)).append("\n");
    sb.append("    userPhone: ").append(toIndentedString(userPhone)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    userAccount: ").append(toIndentedString(userAccount)).append("\n");
    sb.append("    userPassword: ").append(toIndentedString(userPassword)).append("\n");
    sb.append("    sendToUserFlag: ").append(toIndentedString(sendToUserFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
