package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTCUserOrgDTO
 */

@JsonInclude(NON_NULL)
public class MsTCUserOrgDTO {
  @JsonProperty("orgStructId")
  private String orgStructId = null;

  @JsonProperty("fullSelectedFlag")
  private Boolean fullSelectedFlag = null;

  @JsonIgnore
  public MsTCUserOrgDTO orgStructId(String orgStructId) {
    this.orgStructId = orgStructId;
    return this;
  }

   /**
   * 组织id
   * @return orgStructId
  **/
  @ApiModelProperty(value = "组织id")
  public String getOrgStructId() {
    return orgStructId;
  }

  public void setOrgStructId(String orgStructId) {
    this.orgStructId = orgStructId;
  }

  @JsonIgnore
  public MsTCUserOrgDTO fullSelectedFlag(Boolean fullSelectedFlag) {
    this.fullSelectedFlag = fullSelectedFlag;
    return this;
  }

   /**
   * 全选状态，true 全选， false 半选
   * @return fullSelectedFlag
  **/
  @ApiModelProperty(value = "全选状态，true 全选， false 半选")
  public Boolean getFullSelectedFlag() {
    return fullSelectedFlag;
  }

  public void setFullSelectedFlag(Boolean fullSelectedFlag) {
    this.fullSelectedFlag = fullSelectedFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCUserOrgDTO tcUserOrgDTO = (MsTCUserOrgDTO) o;
    return Objects.equals(this.orgStructId, tcUserOrgDTO.orgStructId) &&
        Objects.equals(this.fullSelectedFlag, tcUserOrgDTO.fullSelectedFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orgStructId, fullSelectedFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCUserOrgDTO {\n");
    
    sb.append("    orgStructId: ").append(toIndentedString(orgStructId)).append("\n");
    sb.append("    fullSelectedFlag: ").append(toIndentedString(fullSelectedFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
