package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class MsTCUserRoleAddOrDelRequest {
  @JsonProperty("operatorType")
  private String operatorType = null;

  @JsonProperty("userId")
  private String userId = null;

  @JsonProperty("roleId")
  private String roleId = null;

  @JsonProperty("tenantId")
  private String tenantId = null;

  @JsonProperty("opUserId")
  private String opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonIgnore
  public MsTCUserRoleAddOrDelRequest operatorType(String operatorType) {
    this.operatorType = operatorType;
    return this;
  }

   /**
   * 操作类型 I:新增  D:删除
   * @return operatorType
  **/
  @ApiModelProperty(value = "操作类型 I:新增  D:删除")
  public String getOperatorType() {
    return operatorType;
  }

  public void setOperatorType(String operatorType) {
    this.operatorType = operatorType;
  }

  @JsonIgnore
  public MsTCUserRoleAddOrDelRequest userId(String userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户ID
   * @return userId
  **/
  @ApiModelProperty(value = "用户ID")
  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsTCUserRoleAddOrDelRequest roleId(String roleId) {
    this.roleId = roleId;
    return this;
  }

   /**
   * 角色ID
   * @return roleId
  **/
  @ApiModelProperty(value = "角色ID")
  public String getRoleId() {
    return roleId;
  }

  public void setRoleId(String roleId) {
    this.roleId = roleId;
  }

  @JsonIgnore
  public MsTCUserRoleAddOrDelRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsTCUserRoleAddOrDelRequest opUserId(String opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public String getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(String opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsTCUserRoleAddOrDelRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCUserRoleAddOrDelRequest tcUserRoleAddOrDelRequest = (MsTCUserRoleAddOrDelRequest) o;
    return Objects.equals(this.operatorType, tcUserRoleAddOrDelRequest.operatorType) &&
        Objects.equals(this.userId, tcUserRoleAddOrDelRequest.userId) &&
        Objects.equals(this.roleId, tcUserRoleAddOrDelRequest.roleId) &&
        Objects.equals(this.tenantId, tcUserRoleAddOrDelRequest.tenantId) &&
        Objects.equals(this.opUserId, tcUserRoleAddOrDelRequest.opUserId) &&
        Objects.equals(this.opUserName, tcUserRoleAddOrDelRequest.opUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(operatorType, userId, roleId, tenantId, opUserId, opUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCUserRoleAddOrDelRequest {\n");
    
    sb.append("    operatorType: ").append(toIndentedString(operatorType)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    roleId: ").append(toIndentedString(roleId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
