package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 税盘发票基础信息
 */
@ApiModel(description = "税盘发票基础信息")

@JsonInclude(NON_NULL)
public class MsTSADeviceInvoiceInfoBean {
  @JsonProperty("tenantCode")
  private String tenantCode = null;

  @JsonProperty("tenantName")
  private String tenantName = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("deviceType")
  private String deviceType = null;

  @JsonProperty("deviceCode")
  private String deviceCode = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("isRefinedOil")
  private String isRefinedOil = null;

  @JsonProperty("isManaged")
  private String isManaged = null;

  @JsonProperty("runType")
  private String runType = null;

  @JsonProperty("miName")
  private String miName = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("offlineTime")
  private Integer offlineTime = null;

  @JsonProperty("leftOfflineTime")
  private Integer leftOfflineTime = null;

  @JsonProperty("offlineAmount")
  private String offlineAmount = null;

  @JsonProperty("leftOfflineAmount")
  private String leftOfflineAmount = null;

  @JsonProperty("limitAmount")
  private String limitAmount = null;

  @JsonProperty("leftBlankInvoices")
  private Integer leftBlankInvoices = null;

  @JsonProperty("lastReportDate")
  private String lastReportDate = null;

  @JsonProperty("lockDate")
  private String lockDate = null;

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean tenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
    return this;
  }

   /**
   * 租户代码
   * @return tenantCode
  **/
  @ApiModelProperty(value = "租户代码")
  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean tenantName(String tenantName) {
    this.tenantName = tenantName;
    return this;
  }

   /**
   * 租户名称
   * @return tenantName
  **/
  @ApiModelProperty(value = "租户名称")
  public String getTenantName() {
    return tenantName;
  }

  public void setTenantName(String tenantName) {
    this.tenantName = tenantName;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 税号
   * @return taxNo
  **/
  @ApiModelProperty(value = "税号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean deviceType(String deviceType) {
    this.deviceType = deviceType;
    return this;
  }

   /**
   * 税盘类型 1-百望单盘 2-百望服务器 3-航信单盘 4-航信服务器 5-虚拟ukey 6-税控钥匙 7-税务证书 8-税务ukey
   * @return deviceType
  **/
  @ApiModelProperty(value = "税盘类型 1-百望单盘 2-百望服务器 3-航信单盘 4-航信服务器 5-虚拟ukey 6-税控钥匙 7-税务证书 8-税务ukey")
  public String getDeviceType() {
    return deviceType;
  }

  public void setDeviceType(String deviceType) {
    this.deviceType = deviceType;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean deviceCode(String deviceCode) {
    this.deviceCode = deviceCode;
    return this;
  }

   /**
   * 税盘编号
   * @return deviceCode
  **/
  @ApiModelProperty(value = "税盘编号")
  public String getDeviceCode() {
    return deviceCode;
  }

  public void setDeviceCode(String deviceCode) {
    this.deviceCode = deviceCode;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 开票机号
   * @return machineCode
  **/
  @ApiModelProperty(value = "开票机号")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean isRefinedOil(String isRefinedOil) {
    this.isRefinedOil = isRefinedOil;
    return this;
  }

   /**
   * 成品油资质 0-否 1-是
   * @return isRefinedOil
  **/
  @ApiModelProperty(value = "成品油资质 0-否 1-是")
  public String getIsRefinedOil() {
    return isRefinedOil;
  }

  public void setIsRefinedOil(String isRefinedOil) {
    this.isRefinedOil = isRefinedOil;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean isManaged(String isManaged) {
    this.isManaged = isManaged;
    return this;
  }

   /**
   * 是否托管 0-否 1-是
   * @return isManaged
  **/
  @ApiModelProperty(value = "是否托管 0-否 1-是")
  public String getIsManaged() {
    return isManaged;
  }

  public void setIsManaged(String isManaged) {
    this.isManaged = isManaged;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean runType(String runType) {
    this.runType = runType;
    return this;
  }

   /**
   * 运行模式 百望开票-NisecC UKey开票-UKeyC 航信v2开票-AisinoC AisinoX  航信V3开票-AisinoX2
   * @return runType
  **/
  @ApiModelProperty(value = "运行模式 百望开票-NisecC UKey开票-UKeyC 航信v2开票-AisinoC AisinoX  航信V3开票-AisinoX2")
  public String getRunType() {
    return runType;
  }

  public void setRunType(String runType) {
    this.runType = runType;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean miName(String miName) {
    this.miName = miName;
    return this;
  }

   /**
   * MI 队列名字
   * @return miName
  **/
  @ApiModelProperty(value = "MI 队列名字")
  public String getMiName() {
    return miName;
  }

  public void setMiName(String miName) {
    this.miName = miName;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 票种名称
   * @return invoiceType
  **/
  @ApiModelProperty(value = "票种名称")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean offlineTime(Integer offlineTime) {
    this.offlineTime = offlineTime;
    return this;
  }

   /**
   * 总离线时长 单位小时
   * @return offlineTime
  **/
  @ApiModelProperty(value = "总离线时长 单位小时")
  public Integer getOfflineTime() {
    return offlineTime;
  }

  public void setOfflineTime(Integer offlineTime) {
    this.offlineTime = offlineTime;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean leftOfflineTime(Integer leftOfflineTime) {
    this.leftOfflineTime = leftOfflineTime;
    return this;
  }

   /**
   * 剩余离线时长 单位小时 -1\"未知\"  >=0为正常值
   * @return leftOfflineTime
  **/
  @ApiModelProperty(value = "剩余离线时长 单位小时 -1\"未知\"  >=0为正常值")
  public Integer getLeftOfflineTime() {
    return leftOfflineTime;
  }

  public void setLeftOfflineTime(Integer leftOfflineTime) {
    this.leftOfflineTime = leftOfflineTime;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean offlineAmount(String offlineAmount) {
    this.offlineAmount = offlineAmount;
    return this;
  }

   /**
   * 总离线金额，精度是2位小数  -1\"未知\"
   * @return offlineAmount
  **/
  @ApiModelProperty(value = "总离线金额，精度是2位小数  -1\"未知\"")
  public String getOfflineAmount() {
    return offlineAmount;
  }

  public void setOfflineAmount(String offlineAmount) {
    this.offlineAmount = offlineAmount;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean leftOfflineAmount(String leftOfflineAmount) {
    this.leftOfflineAmount = leftOfflineAmount;
    return this;
  }

   /**
   * 剩余离线金额，精度是2位小数 -1\"未知\"
   * @return leftOfflineAmount
  **/
  @ApiModelProperty(value = "剩余离线金额，精度是2位小数 -1\"未知\"")
  public String getLeftOfflineAmount() {
    return leftOfflineAmount;
  }

  public void setLeftOfflineAmount(String leftOfflineAmount) {
    this.leftOfflineAmount = leftOfflineAmount;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean limitAmount(String limitAmount) {
    this.limitAmount = limitAmount;
    return this;
  }

   /**
   * 发票限额，精度是2位小数
   * @return limitAmount
  **/
  @ApiModelProperty(value = "发票限额，精度是2位小数")
  public String getLimitAmount() {
    return limitAmount;
  }

  public void setLimitAmount(String limitAmount) {
    this.limitAmount = limitAmount;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean leftBlankInvoices(Integer leftBlankInvoices) {
    this.leftBlankInvoices = leftBlankInvoices;
    return this;
  }

   /**
   * 空白发票数量，单位：张  -1\"未知\"
   * @return leftBlankInvoices
  **/
  @ApiModelProperty(value = "空白发票数量，单位：张  -1\"未知\"")
  public Integer getLeftBlankInvoices() {
    return leftBlankInvoices;
  }

  public void setLeftBlankInvoices(Integer leftBlankInvoices) {
    this.leftBlankInvoices = leftBlankInvoices;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean lastReportDate(String lastReportDate) {
    this.lastReportDate = lastReportDate;
    return this;
  }

   /**
   * 最近一次抄报汇总日期   yyyyMMdd
   * @return lastReportDate
  **/
  @ApiModelProperty(value = "最近一次抄报汇总日期   yyyyMMdd")
  public String getLastReportDate() {
    return lastReportDate;
  }

  public void setLastReportDate(String lastReportDate) {
    this.lastReportDate = lastReportDate;
  }

  @JsonIgnore
  public MsTSADeviceInvoiceInfoBean lockDate(String lockDate) {
    this.lockDate = lockDate;
    return this;
  }

   /**
   * 清卡截至日期，过期后税盘锁死不能开票，之后需要到税局解锁
   * @return lockDate
  **/
  @ApiModelProperty(value = "清卡截至日期，过期后税盘锁死不能开票，之后需要到税局解锁")
  public String getLockDate() {
    return lockDate;
  }

  public void setLockDate(String lockDate) {
    this.lockDate = lockDate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTSADeviceInvoiceInfoBean tsADeviceInvoiceInfoBean = (MsTSADeviceInvoiceInfoBean) o;
    return Objects.equals(this.tenantCode, tsADeviceInvoiceInfoBean.tenantCode) &&
        Objects.equals(this.tenantName, tsADeviceInvoiceInfoBean.tenantName) &&
        Objects.equals(this.taxNo, tsADeviceInvoiceInfoBean.taxNo) &&
        Objects.equals(this.companyName, tsADeviceInvoiceInfoBean.companyName) &&
        Objects.equals(this.deviceType, tsADeviceInvoiceInfoBean.deviceType) &&
        Objects.equals(this.deviceCode, tsADeviceInvoiceInfoBean.deviceCode) &&
        Objects.equals(this.machineCode, tsADeviceInvoiceInfoBean.machineCode) &&
        Objects.equals(this.isRefinedOil, tsADeviceInvoiceInfoBean.isRefinedOil) &&
        Objects.equals(this.isManaged, tsADeviceInvoiceInfoBean.isManaged) &&
        Objects.equals(this.runType, tsADeviceInvoiceInfoBean.runType) &&
        Objects.equals(this.miName, tsADeviceInvoiceInfoBean.miName) &&
        Objects.equals(this.invoiceType, tsADeviceInvoiceInfoBean.invoiceType) &&
        Objects.equals(this.offlineTime, tsADeviceInvoiceInfoBean.offlineTime) &&
        Objects.equals(this.leftOfflineTime, tsADeviceInvoiceInfoBean.leftOfflineTime) &&
        Objects.equals(this.offlineAmount, tsADeviceInvoiceInfoBean.offlineAmount) &&
        Objects.equals(this.leftOfflineAmount, tsADeviceInvoiceInfoBean.leftOfflineAmount) &&
        Objects.equals(this.limitAmount, tsADeviceInvoiceInfoBean.limitAmount) &&
        Objects.equals(this.leftBlankInvoices, tsADeviceInvoiceInfoBean.leftBlankInvoices) &&
        Objects.equals(this.lastReportDate, tsADeviceInvoiceInfoBean.lastReportDate) &&
        Objects.equals(this.lockDate, tsADeviceInvoiceInfoBean.lockDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantCode, tenantName, taxNo, companyName, deviceType, deviceCode, machineCode, isRefinedOil, isManaged, runType, miName, invoiceType, offlineTime, leftOfflineTime, offlineAmount, leftOfflineAmount, limitAmount, leftBlankInvoices, lastReportDate, lockDate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTSADeviceInvoiceInfoBean {\n");
    
    sb.append("    tenantCode: ").append(toIndentedString(tenantCode)).append("\n");
    sb.append("    tenantName: ").append(toIndentedString(tenantName)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    deviceType: ").append(toIndentedString(deviceType)).append("\n");
    sb.append("    deviceCode: ").append(toIndentedString(deviceCode)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    isRefinedOil: ").append(toIndentedString(isRefinedOil)).append("\n");
    sb.append("    isManaged: ").append(toIndentedString(isManaged)).append("\n");
    sb.append("    runType: ").append(toIndentedString(runType)).append("\n");
    sb.append("    miName: ").append(toIndentedString(miName)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    offlineTime: ").append(toIndentedString(offlineTime)).append("\n");
    sb.append("    leftOfflineTime: ").append(toIndentedString(leftOfflineTime)).append("\n");
    sb.append("    offlineAmount: ").append(toIndentedString(offlineAmount)).append("\n");
    sb.append("    leftOfflineAmount: ").append(toIndentedString(leftOfflineAmount)).append("\n");
    sb.append("    limitAmount: ").append(toIndentedString(limitAmount)).append("\n");
    sb.append("    leftBlankInvoices: ").append(toIndentedString(leftBlankInvoices)).append("\n");
    sb.append("    lastReportDate: ").append(toIndentedString(lastReportDate)).append("\n");
    sb.append("    lockDate: ").append(toIndentedString(lockDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
