package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsTaxCodeListModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 税编结询返回
 */
@ApiModel(description = "税编结询返回")

@JsonInclude(NON_NULL)
public class MsTaxCodeStructureResult {
  @JsonProperty("parentTaxCode")
  private String parentTaxCode = null;

  @JsonProperty("taxCodeList")
  private List<MsTaxCodeListModel> taxCodeList = new ArrayList<MsTaxCodeListModel>();

  @JsonIgnore
  public MsTaxCodeStructureResult parentTaxCode(String parentTaxCode) {
    this.parentTaxCode = parentTaxCode;
    return this;
  }

   /**
   * 税编上级编码
   * @return parentTaxCode
  **/
  @ApiModelProperty(value = "税编上级编码")
  public String getParentTaxCode() {
    return parentTaxCode;
  }

  public void setParentTaxCode(String parentTaxCode) {
    this.parentTaxCode = parentTaxCode;
  }

  @JsonIgnore
  public MsTaxCodeStructureResult taxCodeList(List<MsTaxCodeListModel> taxCodeList) {
    this.taxCodeList = taxCodeList;
    return this;
  }

  public MsTaxCodeStructureResult addTaxCodeListItem(MsTaxCodeListModel taxCodeListItem) {
    this.taxCodeList.add(taxCodeListItem);
    return this;
  }

   /**
   * 税编结构列表
   * @return taxCodeList
  **/
  @ApiModelProperty(value = "税编结构列表")
  public List<MsTaxCodeListModel> getTaxCodeList() {
    return taxCodeList;
  }

  public void setTaxCodeList(List<MsTaxCodeListModel> taxCodeList) {
    this.taxCodeList = taxCodeList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxCodeStructureResult taxCodeStructureResult = (MsTaxCodeStructureResult) o;
    return Objects.equals(this.parentTaxCode, taxCodeStructureResult.parentTaxCode) &&
        Objects.equals(this.taxCodeList, taxCodeStructureResult.taxCodeList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(parentTaxCode, taxCodeList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxCodeStructureResult {\n");
    
    sb.append("    parentTaxCode: ").append(toIndentedString(parentTaxCode)).append("\n");
    sb.append("    taxCodeList: ").append(toIndentedString(taxCodeList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
