package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 商品分页查询返回
 */
@ApiModel(description = "商品分页查询返回")

@JsonInclude(NON_NULL)
public class QueryGoodsResponse {
  @JsonProperty("code")
  private String code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private MsGoodsPageModel result = null;

  @JsonIgnore
  public QueryGoodsResponse code(String code) {
    this.code = code;
    return this;
  }

   /**
   * 状态 0-失败 1-成功 2-处理中
   * @return code
  **/
  @ApiModelProperty(value = "状态 0-失败 1-成功 2-处理中")
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  @JsonIgnore
  public QueryGoodsResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 返回消息描述
   * @return message
  **/
  @ApiModelProperty(value = "返回消息描述")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public QueryGoodsResponse result(MsGoodsPageModel result) {
    this.result = result;
    return this;
  }

   /**
   * Get result
   * @return result
  **/
  @ApiModelProperty(value = "")
  public MsGoodsPageModel getResult() {
    return result;
  }

  public void setResult(MsGoodsPageModel result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryGoodsResponse goodsListResponse = (QueryGoodsResponse) o;
    return Objects.equals(this.code, goodsListResponse.code) &&
        Objects.equals(this.message, goodsListResponse.message) &&
        Objects.equals(this.result, goodsListResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryGoodsResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
