
package com.xforceplus.ant.system.client.model;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class RedDownloadResult {
    /**
     * 流水号
     */
    private String serialNo;
    /**
     * 处理标记
     */
    private String processFlag;
    /**
     * 处理描述
     */
    private String processRemark;
    /**
     * 红字信息
     */
    private List<RedNotificationResult> redNotificationList;

    @Data
    public static class RedNotificationResult {

        /**
         * 在线申请时唯一id
         */
        private Long businessId;
        /**
         * 原发票代码
         */
        private String originalInvoiceCode;

        /**
         * 原发票号码
         */
        private String originalInvoiceNo;

        /**
         * 原发票发票类型
         */
        private String originalInvoiceType;

        /**
         * 原发票开具日期（yyyyMMdd）
         */
        private String originalInvoiceDate;

        /**
         * 购方税号
         */
        private String purchaserTaxCode;

        /**
         * 购方名字
         */
        private String purchaserName;

        /**
         * 红字信息编号
         */
        private String redNotificationNo;

        /**
         * 销方税号
         */
        private String sellerTaxCode;

        /**
         * 销方名字
         */
        private String sellerName;

        /**
         * 状态代码
         */
        private String statusCode;

        /**
         * 状态信息
         */
        private String statusMsg;

        /**
         * 金额信息
         */
        private InvoiceAmountDto amount;

        /**
         * 填开日期
         */
        private String applyDate;

        /**
         * 红字信息表预览PDF地址
         */
        private String pdfPreviewUrl;

        /**
         * 0-购方已抵扣申请 1-购买方未抵扣申请 2-销方申请
         */
        private Integer applicant;

        /**
         * 税率标识（0-正常发票 1-减按计征 2-差额征收）(虚拟Ukey时暂不支持为1）--在线申请
         */
        private String dupTaxFlag;

        /**
         * 税编版本--在线申请
         */
        private String taxCodeVersion;

        /**
         * 成品油操作类型（成品油时必填，0-成品油涉及销售数量变更 （单位、数量和单价必填）1-成品油仅涉及销售金额变更 （单位、数量和单价为空））
         */
        private String oilMemo;

        /**
         * 红字信息明细
         */
        private List<RedNotificationDetail> detailList;

        @Data
        public static class InvoiceAmountDto {
            /**
             * 含税金额
             */
            private BigDecimal amountWithTax;

            /**
             * 不含税金额
             */
            private BigDecimal amountWithoutTax;

            /**
             * 税额
             */
            private BigDecimal taxAmount;
        }

        @Data
        public static class RedNotificationDetail {
            /**
             * 明细金额
             */
            private DetailAmountDto detailAmount;

            /**
             * 商品信息
             */
            private ProductionDto production;

            /**
             * 税收信息
             */
            private TaxDto tax;

            /**
             * 单价是否含税
             */
            private boolean useWithTax;
        }

        @Data
        public static class DetailAmountDto {
            /**
             * 数量
             */
            private BigDecimal quantity;

            /**
             * 单价
             */
            private BigDecimal unitPrice;

            /**
             * 不含税金额
             */
            private BigDecimal amountWithoutTax;

            /**
             * 不含税金额
             */
            private BigDecimal amountWithTax;

            /**
             * 税额
             */
            private BigDecimal taxAmount;
        }

        @Data
        public static class ProductionDto {
            /**
             * 货物或应税劳务编码(税编)
             */
            private String productionCode;

            /**
             * 货物或应税劳务名称
             */
            private String productionName;

            /**
             * 规格型号
             */
            private String specification;

            /**
             * 单位
             */
            private String unitName;
        }

        @Data
        public static class TaxDto {
            /**
             * 税率
             */
            private BigDecimal taxRate;

            /**
             * 是否享受税收优惠政策，默认值false
             */
            private boolean preferentialTax;

            /**
             * 享受税收优惠政策内容。
             * <p>
             * 0税率时： 根据 zeroTax 的情况，分别填： 免税 / 不征税 / 普通0税率
             */
            private String taxPolicy;

            /**
             * 零税率标志
             * <p>
             * 非0税率: 空
             * <p>
             * 0税率: 0-出口退税1-免税2-不征税3-普通0税率
             */
            private String zeroTax;

            /**
             * 税编版本
             */
            private String taxCodeVersion;
        }
    }
}