package com.xforceplus.ant.system.client.model.goods;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 批量商品同步 响应
 *
 * @Author xiezhongyong
 * @Date 2021-12-02
 */
@Data
public class BatchGoodsSyncResp {

    @ApiModelProperty("总数量")
    private Long total;
    @ApiModelProperty("成功数量")
    private Long successNum;
    @ApiModelProperty("失败数量")
    private Long failureNum;
    @ApiModelProperty("修改失败列表")
    private List<SyncResult> failureList = new ArrayList<>();
    @ApiModelProperty("修改成功列表")
    private List<SyncResult> successList =  new ArrayList<>();

    @Data
    public static class SyncResult {
        @ApiModelProperty("校验消息")
        private String validateMessage;
        @ApiModelProperty("协同商品编码")
        private String coopGoodsNo;
        @ApiModelProperty("商品编码")
        private String goodsNo;
        @ApiModelProperty("商品id")
        private Long id;
        @ApiModelProperty("协同公司税号")
        private String coopCompanyTaxNo;
    }

}
