package com.xforceplus.ant.system.client.model.goods;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * Describe: 商品审核记录查询 请求
 *
 * @Author xiezhongyong
 * @Date 2022-07-18
 */
@Data
public class GetGoodsRecordReq {

    @ApiModelProperty("商品编码")
    private String goodsNo;

    @ApiModelProperty("销方租户id")
    private Long sellerTenantId;

    @ApiModelProperty("销方税号")
    private String sellerTaxNo;

    @ApiModelProperty(value = "税编转换代码")
    private String conversionCode;

    @ApiModelProperty("购方租户id")
    private Long purchaserTenantId;

    @ApiModelProperty("购方税号")
    private String purchaserTaxNo;

    @ApiModelProperty("销方企业名称")
    private String sellerCompanyName;

    @ApiModelProperty("购方的企业名称")
    private String purchaserCompanyName;

}
